The Unmanned Surface Vehicle (USV) project aimed to develop an autonomous boat capable of navigating to waypoints, avoiding obstacles, and collecting survey data. The project’s motivation was fueled by the need for an affordable, safe, and efficient solution for wildlife monitoring, search and rescue, freight transportation, and even data collection.

The design objective and the overall goals included the integration of sensors for perception, location, and communication, the use of microcontrollers for motion control and navigation, and meeting specific operational requirements such as following waypoints, sensing objects, water depth, and operating the USV within specified ranges. Additionally, while it would have been easier to mount the electronics on a boogie board or just attach pool noodles to the tackle box, we aimed for a design that more closely resembled a traditional boat hull with a deck. Nonetheless, this decision was made to ensure that the USV not only functioned effectively but also behaved like a real boat.  

Key features of the USV that ensured an efficient and reliable operation first included our autonomous navigation. The USV, while having manual mode, was designed with autonomous navigation capabilities where the user can set predefined waypoints at the base station and observe as it goes to the desired locations. The autonomy was further enhanced by the obstacle detection and response which allows the boat to detect and avoid objects within its path. Moreover, the USV also has long range communication with a base station for data interpretation and signal commands. This feature was crucial for real-time monitoring, controlling the USV, as well as for transmitting collected data back to the base station for analysis. For performance specifications the USV was also designed to have a maximum range of 2 kilometers and provide a clear view in front of the USV up to a range of 1 kilometer. The USV is also capable of operating at a speed of 1 meter per second, ensuring timely and efficient navigation to the waypoints.

Even with a good design we faced many challenges during testing such as waterproofing the electronics, the boat, fine-tuning control algorithms, and ensuring reliable communication in complex environments. Despite these challenges, we successfully demonstrated the feasibility and effectiveness of our USV design.

Our important achievements included integrating various sensors and control systems into a functional USV, optimizing communication between components, and demonstrating the potential for real-world applications in environmental monitoring and data collection. Moving forward, we aim to further develop our USV by incorporating more advanced obstacle avoidance algorithms, integrating machine learning for decision-making, and improving communication models for longer ranges of environmental monitoring.

