const PropTypes = require('prop-types')

const numberProp = PropTypes.oneOfType([PropTypes.string, PropTypes.number])

const touchableProps = {
  disabled: PropTypes.bool,
  onPress: PropTypes.func,
  onPressIn: PropTypes.func,
  onPressOut: PropTypes.func,
  onLongPress: PropTypes.func,
  delayPressIn: PropTypes.number,
  delayPressOut: PropTypes.number,
  delayLongPress: PropTypes.number
}

const fillProps = {
  fill: PropTypes.string,
  fillOpacity: numberProp,
  fillRule: PropTypes.oneOf(['evenodd', 'nonzero'])
}

const clipProps = {
  clipRule: PropTypes.oneOf(['evenodd', 'nonzero']),
  clipPath: PropTypes.string
}

const definationProps = {
  name: PropTypes.string
}

const strokeProps = {
  stroke: PropTypes.string,
  strokeWidth: numberProp,
  strokeOpacity: numberProp,
  strokeDasharray: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.number), PropTypes.string]),
  strokeDashoffset: numberProp,
  strokeLinecap: PropTypes.oneOf(['butt', 'square', 'round']),
  strokeLinejoin: PropTypes.oneOf(['miter', 'bevel', 'round']),
  strokeMiterlimit: numberProp
}

const fontProps = {
  fontFamily: PropTypes.string,
  fontSize: numberProp,
  fontWeight: numberProp,
  fontStyle: PropTypes.string,
  font: PropTypes.object
}

const transformProps = {
  scale: numberProp,
  scaleX: numberProp,
  scaleY: numberProp,
  rotate: numberProp,
  rotation: numberProp,
  translate: numberProp,
  translateX: numberProp,
  translateY: numberProp,
  x: numberProp,
  y: numberProp,
  origin: numberProp,
  originX: numberProp,
  originY: numberProp,
  skew: numberProp,
  skewX: numberProp,
  skewY: numberProp,
  transform: PropTypes.object
}

const pathProps = Object.assign(
  {},
  fillProps,
  strokeProps,
  clipProps,
  transformProps,
  touchableProps,
  definationProps
)

module.exports = {
  numberProp,
  fillProps,
  strokeProps,
  fontProps,
  clipProps,
  pathProps,
  touchableProps
}
