# 大波浪圓體 Pop Gothic

![大波浪圓體CJK TC預覽](https://github.com/max32002/pop-gothic/raw/master/preview/pop-cjktc-banner.png)

大波浪圓體是[はちまるポップ](https://github.com/noriokanisawa/HachiMaruPop)字體的補字計畫。與原作者的主要差異是調整部件寫法、新增中文字、增加為5個字重、增加一些符號。可以免費商用，歡迎大家自由應用、自由優化、自由改作！

華康少女字體的風格真的很美，這個專案的目標是取代華康少女體，免費可商業用途的字體，希望大家會喜歡。

Pop Gothic Font derived from HachiMaruPop Font.

## 字體特色

### 特色1：彌補繁體中文常用字缺字缺憾

目前 2.145 版的字數是 19,777 字，和原作者的7,462字版本相比，增加了 5,602個中文字：
* 㐁㑁㑑㓟㓤㓾㔂㔇㕤㕸㖅㖗㖟㖤㖭㖮㖸㖹㗁㗘㗭㗱㗼㘔㘝㜍㜢㜭㜮㜳㜺㝗㞹㞾㟲㠏㠸㣌㣔㤉㤕㧁㧌㧎㧒㧡㧣㧩㧹㧻㧾㨂㨑㨨㨪㨻㩆㩮㪐㬹㮀㮣㰵㴘㴙㵡㷮㸐㸰㹹㼈㼓㽎㾀㾊㿸䀐䀟䀪䀫䀯䀴䀹䁅䁐䁯䁺䆀䇶䈪䊃䊗䊩䋐䌈䏲䐴䖳䗁䗆䘆䘥䘶䘼䜄䞚䟓䟘䟠䟩䠡䠷䢍䢢䤴䪴䫀䫌䯋䰳䱝䱵䱽䲅䵟丟丢丫丰么乒乓乜乩亃亄亍亼仃仈仉仚仜仨仩仫仱仳仴仵仸份仿伂伅伈伋伒伓伔伕优伙伢伨伩伬伭伲伻伾伿佁佂佅佈佉佋佌佒佔佘佟你佢佣佤佧佪佫佬佮佲佴佷佸佹佺佾侀侁侄侅侇侉侐侕侗侜侞侰侲侳侷侹侺侻俀俅俇俈俋俌俏俓俙俜俞俠俬俱俴倀倇倈倌倎倓倕倗倘倛倜倠倧倮倯倰倱倲倷值偁偅偋偌偍偎偑偓偛偞偟偠偡偢偣偤偪偭偮偯偱偳偷偺傋傌傎傒傕傖傛傜傝傞傢傣傦傪傮傯傰傺傻傽僁僄僆僇僈僎僓僔僗僝僠僤僦僨僩僪僫僬僯僱僶僾儃儅儇儈儊儋儌儐儑儓儗儜儠儢儣儤儥儦儭儱儳儴儸儹兕兗內冇冈冞冹冼凃凈凊凎凐凓凔凗凘凳凴刁刌刐划刓刖刜刞刟刣刨刲刵剁剉剎剒剜剝剟剡剢剨剫剬剭剮剷剸剹剻剾劀劁劊劋劓劖劻勂勥勪勫勯勻勼匧匾卌卟卡卹厙厝另叵叹叻叼吂吆吇吒吓吔吘吙吜吡吤吥吧吨吪吰吱吳吵吷呁呃呅呇呋呐呔呠呡呢呣呤呦呧呩呫呬呯呲呴呸呾呿咁咂咇咈咍咔咕咖咗咘咚咠咡咦咧咪咭咮咰咱咶咷咺咻咿哃哅哆哊哌哎哏哞哠哧哪哫哯哱哳哶哷哸哹哻哼唁唃唅唈唉唊唋唌唑唒唓唗唚唧唩唪唬唭唰唲唵唶唷唻唼唿啁啃啈啉啊啋啍啐啑啒啕啞啟啡啤啥啦啪啫啲啳啵啶啷啹啿喁喂喈喎喏喑喒喓喔喕喡喢喤喥喦喭喱喲喳喵喺喻喿嗂嗃嗆嗉嗊嗌嗎嗏嗐嗑嗒嗓嗕嗖嗙嗛嗝嗡嗢嗥嗦嗧嗨嗬嗯嗲嗶嗺嗼嘀嘁嘈嘌嘍嘎嘏嘐嘓嘜嘟嘧嘬嘮嘰嘳嘵嘹嘺嘻嘽嘾嘿噀噁噅噆噇噈噉噊噍噓噗噙噚噞噠噢噣噥噦噩噭噮噯噰噱噲噶噹噼嚁嚂嚄嚅嚍嚎嚐嚓嚕嚗嚘嚝嚦嚧嚨嚫嚲嚷嚾囉囊囋囌囍囔囝囟囡囤囥囧囪囫圇圠圢圣圩圪圫圬圮圯圳圴圾坁坅坉坋坌坍坒坔坢坨坫坭坯坱坲坳坵坶坷坻坼坽垀垃垊垌垍垏垗垘垙垛垝垞垟垥垧垮垵垶垸垹垺垻垾埁埂埄埌埏埐埕埗埞埡埢埤埥埦埧埩埪埬埭埮埯埰埱埲埳埵埸埻埽堁堃堄堇堈堉堌堎堐堒堔堘堛堜堞堠堣堦堨堬堭堮堳堷堸堹堿塄塇塈塉塌塍塎塏塓塕塛塝塠塤塥塭塯塴塶塺塻塼塿墀墁墂墆墇墉墊墋墎墏墐墑墔墘墝墠墡墣墥墦墧墩墱墽墿壀壂壈壉壎壏壔壖壚壠壢壧壩壾壿复夔夗夠夤夯奀奒奜奱奵奶奷她奻奼奾妀妅妎妏妐妒妗妘妞妠妡妢妧妮妯妰妱妳妴妵妶妷妸妼妽姀姁姃姄姅姈姊姍姎姏姒姖姘姛姝姞姠姡姣姤姩姬姭姮姱姲姳姵姷姹姺姼姽姾娀娊娌娓娕娖娗娙娛娞娣娭娮娷娸娾婂婃婄婇婈婊婌婍婐婑婒婓婔婕婖婗婘婛婜婝婞婟婠婤婥婧婭婰婷婸婻婼婽媃媄媊媋媌媎媏媐媓媔媗媜媝媞媟媠媢媥媦媧媩媪媬媮媯媰媱媲媳媴媷媹媿嫀嫄嫆嫍嫘嫚嫜嫝嫞嫟嫥嫪嫫嫬嫲嫳嫵嫶嫷嫸嫹嫽嫾嬂嬅嬇嬈嬏嬐嬗嬙嬚嬛嬝嬞嬠嬡嬣嬤嬥嬦嬧嬭嬯嬴嬸嬼嬿孈孌孍孎孓孢孬孮孲孻孽孿宁宄宎宒宓宨尌尔尪尬尷屄屌屜屝屢屳屴屺屻屼岆岈岉岊岋岏岒岓岝岟岠岢岣岥岭岮岯岵峆峈峋峌峎峏峐峒峓峔峖峗峘峬峮峴峸峼峿崁崆崌崍崏崝崞崠崡崤崥崦崨崮崰崲崳崴崵崷崸崹崼崽崿嵁嵃嵅嵉嵑嵢嵣嵥嵧嵨嵫嵱嵲嵺嵼嵽嶁嶆嶍嶒嶓嶕嶙嶟嶠嶧嶩嶫嶱巏巑巔巢巰巿帄帊帎帔帕帗帘帟帢帨帩帴帾幁幊幋幍幏幐幓幘幙幛幜幝幠幧幨幩幪幫幬幭庀庂庤庰庹庾廄廋廔弈弒弝弣弤弨弮弰弳弶彃彄彆彉彋彏彞彤彥彯彴彶彸彽彾徆徉徖徛徜徟徥徦徫徬徯徲徵徶徻徿忀忉忏忐忑忒忔忕忟忡忣忨忪忮忯忳忴忷忺怀怉怊怋怌怍怑怔怗怚怞怢怬怭怳怵恀恄恅恇恉恌恓恔恘恛恞恦恧恮恲恿悀悇悈悎悕悜悝悢您悰悱悷悺悻悾悿惀惁惃惈惊惋惍惏惔惙惛惝惦惵惼惿愄愊愋愐愒愓愔愖愘愜愣愩愫愮愲慀慅慆慏慒慔慖慛慞慪慬慲慺慼憀憉憋憍憒憓憛憢憨憪憭憯憰憱憳憴憸憿懀懁懂懅懏懞懟懠懤懥懧懨懩懪懫懭懮懰懱懵懹懻戃戄戕戠戢戥戶戽戾扐扑扒扔扙扚扜扡扢扤扥扦扭扯扰扲扳扴扷扺扻扽抁抅抆抇抈抋抌抎抏抐抨抪抮抯抰抳抶抺抾抿拁拃拄拋拎拕拖拚拫拰拲拴拸拹拺拻拼拽挀挃挍挎挏挐挓挔挕挖挩挪挬挭挮挱挲挳挴挵挶挷挸挹挻挼捀捁捂捃捄捅捆捇捈捊捋捎捒捔捖捘捙捚捝捥捭捰捱捵捸捼捽捾掁掂掄掅掇掊掍掐掑掔掗掙掜掝掞掤掭掮掯掰掶掽揁揂揇揊揋揌揍揎揕揗揘揙揜揝揞揟揠揢揤揥揦揨揪揫揬揭揰揲揳揹揻揾搉搊搌搐搒搔搕搘搙搛搝搞搠搡搢搣搤搥搧搩搪搫搮搯搵搷搹搽摀摁摃摍摐摑摒摓摔摖摙摛摜摝摞摟摡摨摫摬摭摰摱摲摳摷摹摻摽撂撆撇撊撋撌撍撏撐撖撗撘撙撜撟撢撣撨撬撱撽撿擀擃擄擈擉擊擋擐擕擖擗擙擤擩擭擰擷擸擻擼攁攄攆攉攋攍攎攏攑攔攕攖攙攞攢攦攩攲攽敁敆敉敊敋敔敤敥敧敨敪敯敱敳敺敽敿斒斕斨斪斮斶旂旎旖旤旮旯旰旲旳旴旵旼旽昄昅昈昋昐昑昒昡昢昣昫昲昳昹晅晇晈晊晌晚晛晡晪晬晱晲晷晹晻晼晾暊暌暍暐暔暕暟暡暨暩暪暯暰暱暷暺暻暽曆曈曋曒曗曘曛曞曣曨曫曬曭曮朊朐朓朘朠朣术朳朵朹朻朼朾杅杇杈杋杌杍杔杕杗杚杝杬杮杴杶杸杹杺杻极枃构枆枍枎枑枒枓枔枘枙枟枮枰枵枺柂柃柅柈柌柍柒柙柛柜柟柣查柦柫柭柰柲柶柷柸柺栒栘栚栜栝栟栠栥栦栭栮栯栱栳栵栺栻栿桅桉桊桋桌桭桯桱桲桵桸桹桻梀梂梄梆梇梋梌梒梖梘梜梡梣梩梪梫梬梮梲梴棇棌棎棐棑棓棖棙棜棝棤棦棩棪棫棬棰棱棳棵棶棷棸棼椆椇椊椐椑椓椔椗椩椬椯椲椳椵椷椻楁楂楄楅楇楈楉楋楌楎楏楑楒楖楗楟楣楥楦楩楬楰楱楺楻榆榐榓榖榗榙榚榞榣榤榥榦榨榪榫榬榭榰榶榷榼榽槄槉槏槔槤槦槮槳槴槶槺槾樀樁樆樈樍樏樑樘樠樨樲樴樻樿橂橍橎橏橑橕橚橝橞橧橨橪橯檁檅檇檏檑檒檔檖檘檟檡檥檨檫檯檴檷檺檽櫅櫌櫍櫎櫏櫝櫥櫧櫬櫮櫰櫳櫸櫹櫼欀欃欈欉欋欏欑欓欘欥欨欬欯欱欶欻欼欿歁歂歄歅歆歈歊歕歜歞步歧歭歲歷歾殁殂殈殌殎殏殑殔殗殙殛殟殠殣殦殧殭殮殰殶毃每毗毞毠毢毣毦毹毼毽毿氀氂氄氉氐氖氙氟氥氦氧氨氪氫氮氯氰氳氻汃汆汊汋汌汍汏汑汒汔汙汛污汥汦汩汫汭汴汶汸汻沀沄沅沇沉沋沎沏沔沕沘沬沭沯沰沴沷泀泃泆泇泍泏泒泔泖泜泞泠泧泩泫泭泮泲泵泹洁洃洇洈洉洊洍洎洏洐洑洖洘洚洝洠洧洨洭洮洰洱洴洷洹洺洼洿浂浘浞浠浡浢浥浧浭浰浲浻浼浽浾浿涀涂涃涄涉涊涍涐涑涒涔涗涘涥涪涫涮涱涳涴涷涹涺涻涽涾涿淂淄淈淉淊淍淐淓淔淖淗淚淜淟淢淣淥淩淯淰淴淶渂渃渄渏渢渨渲渴渵渶湀湄湅湆湋湏湑湒湔湕湝湞湠湡湢湣湦湩湳湴湷湸湹溈溉溍溒溓溔溙溚溞溠溡溤溧溫溮溰溱溳溴溹溼溾滃滆滇滈滊滐滒滖滛滜滭滵滶滻滽漀漅漈漊漌漍漙漚漟漦漩漪漭漮漯漰漳漷漻漼漽潎潏潐潑潒潓潕潗潚潞潠潡潢潣潧潫潬潶潽潾澇澉澋澌澍澐澕澠澢澧澨澫澭澮澯澰澲澴澶澺澼澽濇濊濋濌濜濞濦濩濼濿瀀瀆瀌瀎瀙瀤瀴瀸瀹瀺瀼灂灄灇灈灒灚灟灠灤灱灲灴灶灹灺灿炂炃炄炆炑炓炔炕炖炘炚炟炡炣炤炥炨炩炰炲炴炵炶炷炽炾烅烇烊烌烍烐烑烒烓烔烗烘烚烛烜烠烢烤烯烰烳烴烶烷烸烺烻烼焀焅焆焊焋焌焍焐焓焗焞焟焠焢焣焥焮焯焰焱焲焺焿煁煃煄煋煍煏煐煒煓煔煘煝煞煟煠煡煣煨煪煱煲煴煸煻熀熅熆熇熉熐熗熚熛熜熝熞熠熡熥熧熮熰熳熸熻熽熿燀燂燄燆燇燋燏燖燘燙燜燡燤燨燰燱燴燶燸燽爁爃爊爌爔爙爚爝爟爸爹牁牂牄牉牊牏牓牖牞牠牣牮牯牰牳牷牸牼牿犄犅犆犈犉犋犌犍犘犚犛犝犞犡犣犤犥犨犰犴犵犺犽狀狁狅狉狌狑狔狚狜狟狣狤狦狨狪狫狳狶狺狻狾狿猁猇猈猑猓猙猞猢猦猧猭猰猱猲猳猵猺猼獀獂獃獉獊獌獍獐獑獙獚獛獝獞獟獠獡獢獥獦獧獩獫獮獯獳獶獼獽獾玀玁玃玅玎玒玓玔玕玗玝玟玠玡玢玥玦玨玫玬玭玵玶玷玸玹玼玿珃珅珆珇珋珌珓珔珗珙珚珛珜珝珧珨珩珫珴珶珺珼珽珿琀琄琈琊琋琌琍琖琚琛琠琡琣琤琨琫琬琭琯琰琱瑀瑂瑄瑆瑊瑋瑍瑎瑐瑑瑒瑔瑗瑧瑭瑮瑱瑲瑵瑼璀璁璅璆璇璈璊璐璒璔璕璘璚璜璠璣璦璨璩璪璫璯璲璶璸璾璿瓁瓖瓗瓚瓤瓨瓬瓴瓵瓺瓻瓾瓿甀甂甋甐甖產甩甭甽甿畀畇畈畎畽疄疒疕疘疙疢疤疪疴疺痀痁痌痠痤痧痱痹瘀瘐瘓瘙瘜瘦瘩瘸癟癥癮癱癿皉皊皏皒皤皪皫皭皯皵皽皾盅盉盎盔盚盯盰盱盳盵盷盹盺盼眃眅眊眎眏眐眒眕眙眝眡眢眣眧眨眫眭眯眱眲眳眴眵眶眹眻眽眾睃睄睅睊睋睌睍睎睏睒睔睕睖睙睜睞睟睠睢睧睩睪睬睭睮睲睶睷睸睻睼睽瞂瞃瞄瞅瞇瞈瞌瞍瞕瞗瞘瞙瞜瞝瞟瞡瞧瞨瞪瞫瞱瞲瞴瞵瞷瞺矂矄矅矉矌矎矓矔矕矘矝矞矠矨矬矰矱矴矵矶矷矸矹矺矻矽矾矿砃砄砅砆砉砍砎砏砐砑砓砛砝砞砟砢砣砩砪砫砬砭砮砰砱砵砷砸硃硆硈硉硊硌硍硐硒硓硘硜硞硠硢硨硪硭确硱硹硻硾硿碀碃碄碉碏碔碖碘碙碟碠碢碤碥碨碫碬碭碰碲碳碴碷碻磄磈磉磌磎磏磕磝磞磟磣磥磪磳磷磹磺磻磼磾礂礄礉礌礏礐礓礔礗礛礝礞礣礩礱礸礿祂祄祅祆祊祋祌祏祑祒祔祛祜祡祤祧祩祪祫祰祳祴祹祼祽禂禇禈禋禐禒禓禕禖禗禘禚禡禢禨禫禬禭禱禴禶离秅秈种秎秏秔秖秜秝秞秠秥秪秫秭秮秶秷秸秺稂稃稄稅稊稌稐稑稒稓稕稞稢稦稨稫稯稰稴稹穄穇穊穋穌穔穖穘穚穛穜穟穠穨穬穭穮穱穸穾窔窠窣窸竘竤竮竳竻竽笀笁笐笓笪笮笱笴筄筊筠筷箅篙篛篡篾簆簌簞籣籮籲籷籸籹籺籼籽籿粀粄粅粈粊粌粑粔粖粞粣粩粯粴粵粺粻粼粿糈糋糌糍糐糑糔糕糗糙糝糨糬糮糰糽紁紃紇紈紉紌紎紏紑紒紓紖紝紞紟紨紩紱紶紸紻紼紽紾絀絁絇絊絑絒絓絔絕絚絝絟絧絩絪絯絰絺絻絼絿綀綁綃綄綅綆綈綌綍綎綑綒綔綖綝綞綡綦綧綩綪綼緀緁緂緄緅緆緌緎緗緟緣緦緧緮緰緱緶緷緹緺縃縈縍縎縐縑縓縔縕縗縚縜縝縠縥縩縪縭縯縳縸縼縿繀繂繄繅繇繏繐繑繓繗繘繜繟繡繢繨繫繯繳繵繶繷繸繾纀纁纋纍纑纕纗纘纙纚缽缾缿罄罈罊罋罏罡罣羋羒羓羖羜羠羢羥羦羧羬羭羰羳羵羷羺羾羿翀翂翃翇翉翍翎翏翑翗翟翢翮翱翲翵耍耎耏耑耔耖耛耞耟耤耦耩耪耬耰耴耵耷耹耾聃聇聏聐聕聜聝聤聧聬聱聵聸肂肐肒肕肙肜肣肨肫肮肵肼肽胂胅胇胈胉胊胍胏胐胑胔胕胗胘胜胠胣胦胭胮胰胲胳胵胹胺胻胿脀脁脕脖脘脙脝脞脟脡脢脤脥脪脫脬脭脰脺脽腂腃腄腇腈腊腌腍腏腒腖腙腚腛腜腞腠腡腢腤腧腩腬腭腯腲腳腷腼腽膁膄膇膉膋膌膍膎膗膘膙膛膞膟膢膦膧膫膬膭膮膱膲膴膹膻臁臃臄臅臊臏臐臒臕臢臬臽舀舔舕舠舡舢舥舨舯舲舴舺舼舽舿艁艄艅艉艋艎艑艒艓艕艖艗艛艜艡艩艬艵芀芃芄芊芎芓芡芣芨芩芮芴芶芷苖苯苲茍茤茭茷茼茿荃荔荖荸荺荽莆莒莘莧菀菆菈菏菞菣菸萊葔葚葳葴蒚蒞蒨蓀蓓蔣蔥蔪蔫蔻蕒蕳薏薶藿蘑蘸虛虬虭虮虯虰虳虴虷虼蚅蚆蚇蚍蚎蚐蚑蚔蚖蚗蚘蚙蚚蚜蚝蚡蚢蚧蚨蚭蚱蚳蚵蚷蚸蚹蚺蚻蚼蚽蚾蚿蛀蛁蛂蛅蛈蛌蛐蛑蛘蛚蛝蛢蛣蛦蛨蛪蛫蛵蛶蛷蛺蜄蜅蜇蜋蜎蜓蜕蜛蜞蜡蜢蜤蜦蜧蜨蜪蜬蜭蜮蜱蜲蜳蜵蜸蜺蜼蜾蝀蝃蝍蝏蝐蝑蝒蝔蝖蝘蝚蝝蝞蝢蝤蝥蝧蝩蝫蝭蝯蝰蝲蝵蝹蝻螁螃螅螇螈螉螏螐螑螓螕螗螘螜螝螞螬螭螮螰螲螵螹螼螿蟃蟅蟈蟉蟊蟌蟎蟑蟓蟔蟙蟛蟜蟟蟡蟣蟤蟥蟦蟪蟫蟬蟭蟮蟳蟺蠁蠉蠊蠋蠌蠐蠓蠔蠗蠘蠙蠛蠝蠟蠦蠨蠩蠬蠰蠳蠵蠷蠼蠾衃衈衊衧衩衪衭衯衱衴衶衹衼袀袉袑袓袘袚袛袟袧袨袪袶袸袹袺袼袾裀裉裊裋裌裍裎裐裗裞裧裫裬裮裯裰裱裶裷裺褅褆褉褋褑褔褕褖褗褘褙褚褟褡褣褬褲褳褵褾襀襂襆襇襉襏襐襑襒襓襗襘襙襚襛襜襝襡襢襣襩襬襮襱襳襼覕覢覣覷觓觔觕觖觙觛觟觡觢觤觥觩觫觬觭觶訄訏訑訕訞訢訧訬訰訹訿詀詄詅詊詌詎詖詗詘詙詡詨詴詵詶詷詺詻詿誁誃誆誏誐誒誖誙說誫誶誺誻誽諀諃諆諈諉諑諓諕諗諘諙諝諣諨諯諰諲諴諵諻諼諿謅謆謊謏謑謒謓謜謞謤謥謧謮謰謱謵謶譀譂譆譈譊譋譐譑譒譔譕譗譙譠譣譧譨譪譭譸譹譺讂讄讅讈讕讘讜讞谹谽豂豇豉豍豏豔豭豻豽貀貄貆貏貐貑貒貓貕貗貙貚貣貤貥貹貺貾賅賒賕賙賝賟賥賧賬賱賵賹賾贀贂贉贌贗贛赨赩赯赲赸趌趏趕趖趟趡趥趴趵趶趷趹趿跁跅跆跈跍跎跐跑跓跔跕跗跘跙跜跠跢跤跦跧跩跬跮跰跱跲跴跺踀踂踃踄踅踆踇踍踑踒踓踔踕踖踗踘踙踚踛踜踠踡踢踣踤踥踦踧踩踫踭踮踱踲踳踶踸踹踻踼踾踿蹀蹁蹅蹋蹍蹎蹓蹔蹖蹗蹘蹚蹛蹜蹝蹡蹢蹥蹦蹧蹩蹪蹬蹭蹯蹳蹸蹺蹻蹽躂躆躈躉躎躐躒躘躚躝躟躣躦躩躲躺躼躽軀軁軑軓軔軗軘軜軝軞軠軡軥軦軧軨軩軮軯軱軴軵軷軹軺輀輁輆輇輍輎輐輑輖輗輘輚輞輠輣輤輥輬輮輲輴輵輶轀轃轇轈轋轏轐轑轒轓轔轕轖轘轙轞轠辦迆迌迤迨迵适递逛逩逿遛遝遢遰遴邈邋邐邔邕邗邘邙邛邞邠邡邢邥邧邰邲邳邽郃郅郇郈郔郕郖郗郙郚郜郝郟郣郥郩郫郬郯郱郲郳郼郾郿鄀鄃鄄鄇鄈鄉鄋鄍鄏鄔鄖鄗鄘鄚鄛鄜鄝鄞鄟鄣鄤鄦鄫鄯鄱鄴鄵鄶鄹鄺酀酁酄酅酆酇酏酐酕酗酙酚酟酠酡酤酮酯酴酶酹酺酼醀醁醃醄醅醆醊醎醏醑醙醚醛醝醞醡醣醥醧醨醬醭醮醰醱醲醳醷醹醼釂釓釙釨釩釪釫釬釱釳釴釷釸釹鈀鈁鈂鈄鈅鈇鈉鈌鈏鈒鈖鈗鈙鈚鈜鈣鈤鈥鈦鈧鈪鈭鈮鈱鈲鈳鈶鈸鈽鈾鉆鉊鉌鉍鉏鉒鉖鉠鉡鉣鉥鉬鉭鉯鉰鉲鉹鉺鉻鉼鉽鉿銂銆銇銋銌銍銎銗銙銝銠銡銤銥銨銪銫銬銲銳銴銵銶銻銼鋁鋂鋃鋅鋇鋉鋊鋋鋌鋍鋎鋑鋘鋝鋞鋟鋡鋦鋨鋮鋯鋰鋾錀錁錄錈錉錋錍錎錑錔錕錟錤錧錩錪錭錳錴錶錸錹錼鍆鍇鍉鍊鍎鍏鍑鍒鍕鍘鍚鍞鍡鍤鍥鍭鍱鍶鍷鍹鍺鍻鎂鎈鎉鎊鎍鎎鎑鎒鎕鎘鎝鎞鎟鎡鎢鎦鎨鎩鎪鎯鎱鎳鎴鎵鎷鏀鏂鏄鏌鏍鏎鏒鏕鏙鏜鏟鏢鏣鏦鏮鏵鏶鏷鏹鏻鏽鏾鐀鐈鐉鐌鐍鐎鐏鐕鐠鐩鐪鐬鐮鐰鐲鐳鐻鐼鐿鑀鑇鑊鑌鑏鑐鑕鑣鑤鑨鑩鑫鑭鑱鑲鑴钂钃镹镺镻镽閎閕閡閩閱闆闈闋闐阞阠阢阣阤阬阭阰阱阳阹阺阼阽陁陊陎陑陓陔陖陘陡陫陭陯陱陴陻陼隀隃隄隇隑隒隖隞隡隢隤隥隩隬隮雊雒雞雩雯雱雸雺雿霅霉霒靗靘靚靛靪靬靮靰靲靳靶靷靸靻靽鞀鞂鞈鞊鞎鞔鞙鞚鞝鞞鞮鞽韁韄韇韌韍韎韐韔韕韖韗韘韙韝韞韟韡韣韥韸韹韺頀頇頊頎頕頖頛頜頝頦頧頨頩頰頶頹顃顉顓顝顟顠顤颳颺颼飁飣飥飧飪飶飹飺餀餂餇餈餑餕餖餗餚餛餟餥餦餫餭餯餱餲餳餵餿饁饃饇饈饎饘饛饜饞饟饡馡馦馯馰馱馲馹駂駃駇駋駌駍駎駏駓駔駖駗駙駜駣駤駥駧駩駪駬駶駷駺駼駽駾騂騃騄騆騇騉騊騋騍騑騔騖騛騜騝騠騥騧騩騪騮騵騸騹騽騿驆驈驉驊驒驓驔驜驞骫骯骱骳骴骷骹骻骾骿髁髂髇髊髐髒髕髖髡鬃鬍鬽魛魟魠魡魤魦魧魨魩魬魰魱魶魷魺魻魼魽魾鮀鮁鮅鮆鮇鮈鮊鮐鮔鮕鮘鮚鮞鮡鮢鮥鮦鮯鮵鮶鮸鮽鮿鯁鯃鯄鯇鯌鯓鯕鯙鯚鯜鯠鯥鯧鯪鯬鯮鯷鯻鯽鯿鰅鰇鰎鰜鰝鰨鰩鰫鰱鰶鰼鰽鰿鱄鱉鱊鱌鱎鱐鱔鱕鱖鱘鱙鱞鱢鱣鱦鱲鱷鳪鳭鳵鳺鳻鳼鳿鴗鴙鴝鴞鴭鴮鴯鴰鴶鴽鵃鵅鵊鵌鵒鵓鵔鵗鵘鵛鵧鵪鵸鵹鵻鵿鶀鶁鶄鶝鶞鶡鶣鶬鶵鶼鶾鷊鷌鷎鷗鷚鷝鷤鷥鷮鸃鸅鸇鸈鸐鸕鹼麂麃麴麵黃黓黕黗黚黟黢黤黦黧黫黮黰黲黺鼙鼯鼴鼽齀齁齂齃齕齖齗齘齙齜齝齞齮齯齰齺龐龔龢𠆩𠆫𠇁𠇔𠇲𠈄𠉵𠊎𠊙𠊿𠋥𠌥𠌬𠎠𠎧𠎷𠕆𠕇𠖄𠗙𠗻𠚺𠚼𠛎𠛒𠛓𠛪𠜖𠜱𠞩𠞭𠟄𠠁𠠃𠠝𠢕𠮾𠯗𠯤𠰍𠱸𠲛𠲥𠲿𠴼𠺕𠼖𠽾𠿪𡛼𡜍𡜺𡝗𡝮𡝯𡝴𡞫𡞰𡞱𡞵𡟓𡟙𡟵𡟼𡠪𡢃𡢄𡳞𡶺𡼧𢁾𢄑𢎙𢓜𢖲𢛔𢛟𢜳𢪱𢫦𢫫𢯭𢯾𢱋𢱤𢲴𢲸𢳆𢳪𢶀𢶉𢼌𢼛𣁳𣁴𣅒𣆯𣍐𣏌𣏞𣏹𣏾𣐿𣑲𣕂𣖙𣖜𣗍𣢇𣧃𣮈𣲩𣳽𣻸𣼎𤆬𤉙𤊶𤌍𤍒𤐙𤐰𤘅𤜤𤞚𤣯𤧷𤧸𤨎𤨒𤨢𤨧𤨪𤩎𤩧𤰦𤲍𤶃𤸁𤸱𤿩𥄹𥆌𥆍𥇇𥈅𥉌𥉔𥉘𥌚𥍉𥐵𥑮𥯟𥰔𥴊𥺆𦉎𦊓𦘴𦜆𦟪𦨎𦩫𧉟𧊅𧌄𧘐𧟰𧩣𧯝𧲢𧻴𧿌𧿬𧿳𨂾𨃰𨅔𨑨𨒇𨢑𨦨𨲭𩑝𩑾𩚨𩛩𩜄𩜰𩵚𩵱𩶅𩷹𩸙𩸞𩸶𩼧𩽏𪁎𪐞𪖐𪘒𪜶𪹚𫝏𫝘𫝙𫝛𫝻𫞼𫟂𫟧𫠛𫣆𬠖𬦰𰣻𰹬𱱿󸿭

附註
* 1：由於是非專業級的補字，新加入的字在風格上，雖然盡力求一致，難免會與原作者會有一些不同或很醜，覺得很醜的字，如果有人提出來，萬一有空的話，會找時間重做。
* 2：原作者的部件是使用日本寫法，補的字目前是使用台標體，混搭起來有時候會怪怪的，聊勝於無。
* 3：如果你也有補好的字，歡迎與我分享。

### 特色2：5種字重(Style)
![5種字重](https://github.com/max32002/pop-gothic/raw/master/preview/compare_styles.jpg)

* Light
* DemiLight
* Regular (原作者的字重)
* SemiBold
* Bold

原作者的字重放在Regular字重裡，透過程式自動產生Light、DemiLight、SemiBold、Bold 新的字重。

在ExtraLight和Light字重是把原作者Regular字重微微調細一點點。在Light的字重裡，可能會因為筆劃太細造成某些筆畫消失。

在SemiBold與Bold的字重裡，可能會因為筆劃太粗造成某些筆畫重疊難以識別，有粗體字的需求，可以先挑戰使用Bold字重看看，如果發現效果不如預期，再改用SemiBold字重。

不能確定自動產生出來的字重裡每一個都是完整的字，畢盡程式會誤判是常有的事情，所以「不是在Regular字重」裡的筆劃可能會消失。

### 特色3：調整標點符號位置

原作者的全形標點符號針對日本做設計，調整為台灣常見的置中用法。

### 特色4：增加臺灣閩南語和客語的部份中文字

例如：
* 𠢕𡳞癩𰣻㘔勥奒𠊎𠖄𠯗𠲿𢪱𢫦𢯾𢱤𢲴𢲸𣁳𣻸𤉙𤌍𤍒𤐰𤞚𥌚𧉟𧩣𧿬𩑾𩚨𩜰𩵱𪖐𪜶𫝻𬠖𬦰

### 特色5：調整部件寫法

相同一個字，在不地區的書寫方式可能會略有不同，原作者的字都放 CJK JP的字型檔案裡。

CJK JP 與 CJK TC 有差異的字：(578字)
* 㔂㗱㤉㧎㴘亂仗仞伻侮侵俘俸倦偉偏偖偸傑傔催僊僘僧僭儁儲儺兤具准凈凋凖券剏割劵勇勤勸包匯博卷厰呯哹唐售唯唳唾啓啥善喝喫喻嗔嗝嘆噅噌噍器嚓嚮嚼囃囉囎圈埒埤埴埵堆塌塘填增墨墫墸壅壙奉奏契奚奝奠奢奪奮妳婦婬孚孵害寀寉寘察尋就層岼峭崔崢嵭嶂巷巽帷幃幤幹庖廉廊廣廱弧急怦悄悔惆惓惟惷慊慎慥慧慨憎憐憔應懸懼懽截戳戻房所扇扈扉才扨抨抱拌拳捎捧捨捩捲掃推揄揍揹搧搩搪携摔摖摠摧撍撝撨撰擁擢擦擲擴攤攫敏敝敞敷斃旁旅春晧暐暙暹暼曜曠書杓杖枒柧桊桴梅梏棈棒植椎椦椿楡楮概榔榛槙横樵橫櫂欄權歉歡殍殖殺毒氣沉泙泡泰海浸淌淚淨淫淮渙渣港湊湧湲溏準溪滔滕滬漢潔潛濂濯瀇灌灘灼炉焦煥煽燐燿爭牘牙犢猜獲獷獻獾玀瑣瑯瑶璀瓜瓠瓢瓣甑甕癨癰癲皀真睛睡瞋瞎瞥矗砲碓確磔礁礦祢祭禔禛禢秦程稍稙稚稠稱稻穩穴穿突窖窗窘竇竫箏箞篇簓簧簾簿籐籘籬籾糖紉納絆綏綞綟綢綣維綮綵編緯練縊縛縢縣總繁繒繕纊續罇罐置罹羅翟翩耀聚聰肇肩胖胞膊膎膳膺臻舂舊艀茣菶蓁蔽蕉蕕薄薇藺蘭蘿虐虞虧蜉蜩蜷蜻蝙螂融蟀蠢衂衢袢褊襍覓覩訒誚誤誥誰調諍諱謁護讀谿豁豢豬豹賣賰賺贈贋贖赭起趙踩踭踴蹈蹊蹲躇躍躑躙躪軅軈輳辭逍進遍遒遢遷選邏郛鄰酋鉅銷鋿錐錘錚鍰鎉鎮鎰鎹鐫鑊鑛鑵鑼钁閉闍隆隔隘際隣隧隱隹隻隼雀雁雄雅集雇雉雋雌雍雎雑雕雖雙雛雜離難雪霄霍靕靜靠鞄韋韓響頻顛顴飽餒餝餧饗騅驎驟驩鬲鬻鮃鮹鯛鰀鰆鰌鰥鰨鱈鱗鵠鵰鶴鷁鷄鷏鷦鷹鸛麟麥麩麪麭麵黛黷隆𤌍𤐰𰣻

有些字，原作者可能寫錯了，有反應到上游(upsteam)了。
* 寂

只在CJK TC修正部件寫法：
* 㔂㗱㤉㧎凈呯哹啥嗝噍嚓囉埤惆。
* 戾，大修改為犬：唳捩綟。
* 戶、扁。
* 者，消除多的一點。
* 直、真、具。
* 酋、益。
* 查。
* 隹。
* 眾。
* 鬲。
* 勇。
* 尃。
* 舀、采、爭、奚。
* 堇、漢。
* 吳。
* 賣。
* 瓜。
* 青。

因為工程滿浩大的，還有很多字的部件，沒有一致，糸部也還沒有改，因為要修改的數目好多，一看到就沒力氣了，呵呵。

字體後面的 JP,TC是什意思？

* TC是 Traditional Chinese 繁体中文，代表港台習慣的字形。
* JP是 Japanese 日文，代表日本習慣字形。

### 特色6：補齊中文大寫金額

* 零壹貳參肆伍陸柒捌玖拾佰仟萬億兆圓角分整。

### 特色7：補齊中文注音符號

![注音符號預覽](https://github.com/max32002/pop-gothic/raw/master/preview/bopomofo.png)

* ㄅㄆㄇㄈㄉㄊㄋㄌㄍㄎㄏㄐㄑㄒㄓㄔㄕㄖㄗㄘㄙㄚㄛㄜㄝㄞㄟㄠㄡㄢㄣㄤㄥㄦㄧㄨㄩ

## 更新日誌
[點擊此處](https://github.com/max32002/pop-gothic/blob/master/change_log.md) 查看更新記錄。


## 下載字型

請點選GitHub此畫面右上綠色「Clone or download」按鈕，並選擇「Download ZIP」，或點進想下載的ttf字型檔案，再點「Download」的按鈕進行下載。

## 網頁字型(Web Font)服務

網頁字型用於網頁上的字型顯示，訪客不需預先安裝字型檔，一樣能夠看到特殊的字型效果。不只是電腦，在智慧型手機和平板裝置的瀏覽器上也可正常顯示。實現該功能的原理是在瀏覽時才下載字型檔。

WebFont可以服用下面的css:
```
@font-face {
  font-family: pop-gothic-cjktc;
  src: url(https://cdn.jsdelivr.net/gh/max32002/pop-gothic@2.143/webfont/CJK%20TC/PopGothicCjkTc-Regular.woff2) format("woff2");
}
@font-face {
  font-family: pop-gothic-cjkjp;
  src: url(https://cdn.jsdelivr.net/gh/max32002/pop-gothic@2.143/webfont/CJK%20JP/PopGothicCjkJp-Regular.woff2) format("woff2");
}
```
附註：Regular換成其他的值，可以調整粗細。

## 已知問題

* 這不是一個專業的字型檔案。
* 很多補出來的字，有點怪怪的，如果你有較好的版本，希望可以分享給我，謝謝。

## 著作權與授權

* 本字型是基於 SIL Open Font License 1.1 改造zenfont 所開發、發表的「[はちまるポップ](https://github.com/noriokanisawa/HachiMaruPop)字體」字型。
* 本字型亦基於 SIL Open Font License 1.1 授權條款免費公開，關於授權合約的內容、免責事項等細節，請詳讀 License 文件。
    * 可自由商用 不需付費、知會或標明作者，即可自由使用此字型，亦可做商業應用。
    * 可自由傳布 可自由分享檔案、將檔案安裝於任何軟硬體中。
    * 可自由改作為其他字型 將字型檔案修改重製為其他字型檔案，改作後的字型檔案須同樣依 Open Font License 釋出。

字體授權小提示：本字型採用 SIL Open Font License 1.1 授權發表，可以免費商用。在 github 上有附上 SIL Open Font License 1.1 的授權文件，如甲方或公司需要出示授權文件，直接使用此文件即可。

## 致謝 Acknowledgements

沒有下列的這些優秀的網友分享，不會有這一個字型可以與大家分享，特別感謝下列的專案。
* [pix2pix-tensorflow](https://github.com/yenchenlin/pix2pix-tensorflow) by [yenchenlin](https://github.com/yenchenlin)
* [Domain Transfer Network](https://github.com/yunjey/domain-transfer-network) by [yunjey](https://github.com/yunjey)
* [ac-gan](https://github.com/buriburisuri/ac-gan) by [buriburisuri](https://github.com/buriburisuri)
* [dc-gan](https://github.com/carpedm20/DCGAN-tensorflow) by [carpedm20](https://github.com/carpedm20)
* [origianl pix2pix torch code](https://github.com/phillipi/pix2pix) by [phillipi](https://github.com/phillipi)
* [zi2zi](https://github.com/kaonashi-tyc/zi2zi) by [kaonashi-tyc](https://github.com/kaonashi-tyc)
* [zi2zi-pytorch](https://github.com/xuan-li/zi2zi-pytorch) by [xuan-li](https://github.com/xuan-li)
* [zi2zi-pytorch](https://github.com/EuphoriaYan/zi2zi-pytorch) by [EuphoriaYan](https://github.com/EuphoriaYan)
* [Font2Font](https://github.com/jasonlo0509/Font2Font) by [jasonlo0509](https://github.com/jasonlo0509)
* 感謝網友 Hoopoe 提供的補字。

## 使用電腦做筆跡學習
參考看看這篇文章：
* AI造字經驗分享：[https://max-everyday.com/2021/07/zi2zi-ai-font/](https://max-everyday.com/2021/07/zi2zi-ai-font/)

## 相關影片

* 大波浪圓體補字：注音符號 https://youtu.be/IkbokhlvPik
* 大波浪圓體補字：2022-06-03 https://youtu.be/I_6l5KC_gu0
* 大波浪圓體補字：2022-06-01 https://youtu.be/ors3B1t9oBk
* 大波浪圓體補字：你佣偸粼 https://youtu.be/uhztw7b38aA
* 大波浪圓體補字：旎旖曆步歲歷溼煞 https://youtu.be/KK9PA9Gp4tg
* 大波浪圓體補字：口部 [https://youtu.be/eMLZxgJWzrk](https://youtu.be/eMLZxgJWzrk)
* 以描摹方式建立或更新字型 [https://youtu.be/xSAN43F3wwI](https://youtu.be/xSAN43F3wwI)


## 相關網頁

花園家族：
* B2花園 B2 Hana
https://max-everyday.com/2020/08/b2-hana-font/
* 花園肉丸 Hana Meatball
https://max-everyday.com/2020/08/hana-meatball/

簡體/繁體轉換家族：
* 獅尾簡腿黑體 Swei Jay Leg
https://max-everyday.com/2020/11/swei-jay-leg/
* 獅尾簡中黑體 Swei Jay Sans
https://max-everyday.com/2020/11/swei-jay-sans/
* 獅尾簡中宋體 Swei Jay Serif
https://max-everyday.com/2020/11/swei-jay-serif/
* 獅尾繁腿黑體 Swei Fan Leg
https://max-everyday.com/2020/11/swei-fan-leg/
* 獅尾繁中黑體 Swei Fan Sans
https://max-everyday.com/2020/11/swei-fan-sans/
* 獅尾繁中宋體 Swei Fan Serif
https://max-everyday.com/2020/11/swei-fan-serif/

獅尾黑體家族：
* 獅尾右下腿黑體 Swei Right Bottom Leg
https://max-everyday.com/2021/08/swei-right-bottom-leg/
* 獅尾右下圓黑體 Swei Right Bottom Sans
https://max-everyday.com/2021/08/swei-right-bottom-sans/
* 獅尾飛腿黑體 Swei Dart Leg
https://max-everyday.com/2020/11/swei-dart-leg/
* 獅尾飛鏢黑體 Swei Dart Sans
https://max-everyday.com/2020/11/swei-dart-sans/
* 獅尾火腿黑體 Swei Match Leg
https://max-everyday.com/2020/11/swei-match-leg/
* 獅尾火柴黑體 Swei Match Sans
https://max-everyday.com/2020/11/swei-match-sans/
* 獅尾骨腿黑體 Swei Bone Leg
https://max-everyday.com/2020/11/swei-bone-leg/
* 獅尾骨頭黑體 Swei Bone Sans
https://max-everyday.com/2020/11/swei-bone-sans/
* 獅尾斧腿黑體 Swei Ax Leg
https://max-everyday.com/2020/11/swei-ax-leg/
* 獅尾斧頭黑體 Swei Ax Sans
https://max-everyday.com/2020/11/swei-ax-sans/
* 獅尾喇腿黑體 Swei Bell Leg
https://max-everyday.com/2020/11/swei-bell-leg/
* 獅尾喇叭黑體 Swei Bell Sans
https://max-everyday.com/2020/11/swei-bell-sans/
* 獅尾惡腿黑體 Swei Devil Leg
https://max-everyday.com/2020/11/swei-devil-leg/
* 獅尾惡魔黑體 Swei Devil Sans
https://max-everyday.com/2020/11/swei-devil-sans/
* 獅尾麥腿黑體 Swei Marker Leg
https://max-everyday.com/2020/10/swei-marker-leg/
* 獅尾麥克黑體 Swei Marker Sans
https://max-everyday.com/2020/10/swei-marker-sans/
* 獅尾詠腿黑體 Swei Fist Leg
https://max-everyday.com/2020/10/swei-fist-leg/
* 獅尾詠春黑體 Swei Fist Sans
https://max-everyday.com/2020/10/swei-fist-sans/
* 獅尾鋸腿黑體 Swei Alias Leg
https://max-everyday.com/2020/10/swei-alias-leg/
* 獅尾鋸齒黑體 Swei Alias Sans
https://max-everyday.com/2020/10/swei-alias-sans/
* 獅尾尖腿黑體 Swei Spike Leg
https://max-everyday.com/2020/10/swei-spike-leg/
* 獅尾尖刺黑體 Swei Spike Sans
https://max-everyday.com/2020/10/swei-spike-sans/
* 獅尾快腿黑體 Swei Shear Leg
https://max-everyday.com/2020/09/swei-shear-leg/
* 獅尾快剪黑體 Swei Shear Sans
https://max-everyday.com/2020/09/swei-shear-sans/
* 獅尾福腿黑體 Swei Gospel Leg
https://max-everyday.com/2020/09/swei-gospel-leg/
* 獅尾福音黑體 Swei Gospel Sans
https://max-everyday.com/2020/09/swei-gospel-sans/
* 獅尾D滷腿黑體 Swei Del Luna Leg
https://max-everyday.com/2020/09/swei-del-luna-leg/
* 獅尾德魯納黑體 Swei Del Luna Sans
https://max-everyday.com/2020/09/swei-del-luna-sans/
* 獅尾彎腿黑體 Swei Curve Leg
https://max-everyday.com/2020/09/swei-curve-leg/
* 獅尾彎黑體 Swei Curve Sans
https://max-everyday.com/2020/09/swei-curve-sans/
* 獅尾霓腿黑體 Swei Bow Leg
https://max-everyday.com/2020/09/swei-bow-leg/
* 獅尾霓黑體 Swei Bow Sans
https://max-everyday.com/2020/09/swei-bow-sans/
* 獅尾蝙蝠圓體 Swei Bat Sans
https://max-everyday.com/2020/09/swei-bat-sans/
* 獅尾牙膏圓體 Swei Toothpaste
https://max-everyday.com/2020/09/swei-toothpaste/
* 獅尾三腿黑體 Swei 3T Leg
https://max-everyday.com/2020/09/swei-3t-leg/
* 獅尾三角黑體 Swei 3T Sans
https://max-everyday.com/2020/08/swei-3t-sans/
* 獅尾螺帽腿黑體 Swei Nut Leg
https://max-everyday.com/2020/08/swei-nut-leg/
* 獅尾螺帽黑體 Swei Nut Sans
https://max-everyday.com/2020/08/swei-nut-sans/
* 獅尾B2腿黑體 Swei B2 Leg
https://max-everyday.com/2020/07/swei-b2-leg/
* 獅尾B2黑體 Swei B2 Sans
https://max-everyday.com/2020/07/swei-b2-sans/
* 獅尾腿圓 Swei Gothic Leg
https://max-everyday.com/2020/08/swei-gothic-leg/
* 獅尾彩虹腿 Swei Rainbow Leg
https://max-everyday.com/2020/08/swei-rainbow-leg/
* 獅尾XD珍珠 Swei XD Pearl
https://max-everyday.com/2020/07/swei-xd-pearl/
* 獅尾D露西 Swei D Lucy
https://max-everyday.com/2020/07/swei-d-lucy/
* 獅尾半月字體 Swei Gothic
https://max-everyday.com/2020/04/swei-half-moon/
* 台灣圓體 TaiwanPearl
https://max-everyday.com/2020/06/taiwanpearl/
* 獅尾圓體 Swei Gothic
https://max-everyday.com/2020/04/swei-gothic/
* 獅尾黑體 Swei Sans
https://max-everyday.com/2020/03/swei-sans/

獅尾宋體家族：
* 獅尾B2加糖宋體 Swei B2 Sugar
https://max-everyday.com/2020/11/swei-b2-sugar/
* 獅尾加糖宋體 Swei Sugar
https://max-everyday.com/2020/11/swei-sugar/
* 獅尾B2宋朝 Swei B2 Serif
https://max-everyday.com/2020/07/swei-b2-serif/
* 獅尾肉丸 Swei Meatball
https://max-everyday.com/2020/06/swei-meatball/
* 獅尾四季春字體 Swei Spring
https://max-everyday.com/2020/04/swei-spring/

其他字體：
* 馬路口圓體 Maruko Gothic
https://max-everyday.com/2021/07/maruko-gothic/
* 苦累蛙圓體 Kurewa Gothic
https://max-everyday.com/2021/06/kurewa-gothic/
* 何某手寫體 Nani Font
https://max-everyday.com/2020/09/nanifont/
* 內海字體  Naikai Font
https://max-everyday.com/2020/03/naikaifont/
* 莫大毛筆字體 Bakudai Font
https://max-everyday.com/2020/03/bakudaifont/
* 正風毛筆字體 Masa Font
https://max-everyday.com/2020/05/masafont/
* 假粉圓體 Fake Pearl 
https://max-everyday.com/2020/03/open-huninn-font/
* 俊羽圓體 Yu Pearl 
https://max-everyday.com/2020/03/yupearl/

其他網站：
* 清松手寫體 JasonHandWriting
https://jasonfonts.max-everyday.com/
* Max學習字體相關的筆記
https://codereview.max-everyday.com/font-readme/

## 贊助Max

很高興可以替中華民國美學盡一分心力、讓台灣擁有更好的文字風景，希望能提供另一種美學讓大家選擇。

如果你想支持或打賞Max，贊助方式如下：
https://max-everyday.com/about/#donate
