---
sidebarDepth: 3
---

# zkSync contracts v5.1 upgrade announcement

<!-- markdownlint-disable MD034 -->

Please note, that the upgrade comes as an amendment of the [previous one](../2021-02-26-upgrade). And contains all the
changes that it had, but brings a lot of new features as well.

This upgrade brings native NFT and atomic swaps/limit orders support. This upgrade requires regenerating the root hash
and so requires the most trust from our users, more on that can be read
[here](https://medium.com/matter-labs/zksync-1-x-swaps-nfts-event-system-and-permissionless-token-listing-e126fcc04d61).

## Changes

The exact changes in the code of the contracts
[can be found here](https://github.com/matter-labs/zksync/compare/contracts-5…contracts-5.1?file-filters[]=.sol).

### Added

- `MintNFT`, `WithdrawNFT` operations, which enable native NFT support. More on the NFT structure can be read
  [here](../../dev/nfts).
- `Swap` operation, which depending on the implementation may serve either atomic swaps or limit orders functionality.
  You can read more [here](../../dev/swaps).
- The security council, which is able to shorten the upgrade notice period. More on that
  [here](https://medium.com/matter-labs/keeping-funds-safe-a-3-factor-approach-to-security-in-zksync-2-0-a70b0f53f360).
- `RegeneisMultisig.sol` to handle submissions of the new root hash by the security council during the upgrade.
- A special account with id `2**24 - 1`. It is used to ensure the correctness of the NFT data.

### Changed

- The maximum amount of tokens that can be used to pay transaction fees is increased to 1023.
- The account tree depth for each account increased to `32`.
- Due to the smart contract size limitations, `ZkSync.sol` was split into two parts: the original `ZkSync.sol` and the
  `AdditionalZkSync.sol`, to which some functionality is delegated.
- `ZkSyncNFTFactory.sol` which serves as a default NFT factory, where all the NFTs are withdrawn by default.
- Various minor / stylistic fixes.
