# zkSync Lite API Reference Overview

## Meta

- [Changelog and notifications for developers](./changelog)
- [Development and production environments](./environments)

## API

- [API v0.1](./v0.1) (REST + JSON RPC)

## SDK

zkSync Lite support has been implemented for various platforms:

- [JavaScript / TypeScript](./sdk/js)
- [Rust](./sdk/rust)
- [Android (Java)](./sdk/java)
- [iOS (Swift)](./sdk/swift)
- [Python](./sdk/python)

## Ecosystem libraries

This section also covers the ecosystem libraries we maintain:

- [Cryptographic backends](./sdk/crypto): support of zkSync cryptography in different programming languages.
- [zkCheckout](./sdk/checkout): TypeScript library to integrate zkSync payments for your application.
- [Schnorr MuSig](https://github.com/matter-labs/schnorr-musig): Rust / WASM library for multisig support.
