# Ex&#46;Co&#46; <img src="https://github.com/matkuki/Ex-Co/blob/master/resources/exco-icon.png" align="top" width="48" height="48">
### Descripton: ###
Ex&#46;Co&#46; (Extensible Coder) is a GUI text editor written in Python that uses PyQt/QScintilla libraries with some lexers available in Cython for more efficient text highlighting.
I developed it with simplicity of use and extensibility in mind.<br>
For precompiled bundles for Windows see the releases page (https://github.com/matkuki/ExCo/releases/latest).
<br><br>
### Website: ###
http://matkuki.github.io/ExCo/
<br>
### Quick features video: ###
https://www.youtube.com/watch?v=v-7fqJGv7Ts&feature

### License: ###
__GNU General Public License v3.0__

Copyright (c) 2013-2023 Matic Kukovec. All rights reserved.
  
#### Additional licenses: ####
All additional licenses are specified at the beginning of every source code file and in text file format in the ```additional_licenses``` directory. If I made any mistakes, please open an issue.
<br><br>

### Some features: ###
- **New multi-window layout system**
- All standard text editor functionality (copy, cut, paste, ...)
- 'Function wheel' for quick access to most of Ex&#46;Co&#46;'s functionality
- Integrated Python single/multi-line REPL (Read-Eval-Print Loop) for direct access/manipulation of each editor window text and all other functionality
- Text diffing (also between editor windows)
- Execute Terminal/Shell commands directly from the REPL (Windows or Linux)
- Ability to add your custom Python functions
- Language syntax highlighting: AVS, Ada, Bash, Batch, CMake, CPP, CSS, CSharp, CoffeeScript, Cython, D, Diff, Fortran, Fortran77, HTML, IDL, Java, JavaScript, Lua, Makefile, Matlab, Nim, Oberon, Octave, PO, POV, Pascal, Perl, PostScript, Properties, Python, RouterOS (MikroTik), Ruby, SQL, Spice, TCL, TeX, Text, VHDL, Verilog, XML and YAML
- Code tree displaying for: 
    - Python 3
    - Nim
    - C
    - Many more to come ...
<br><br>

### Supported platforms: ###
- __Windows__ ([precompiled binaries available](https://github.com/matkuki/ExCo/releases))
- __Linux__ (tested on Ubuntu, Lubuntu, Mint, Fedora, Raspbian (Raspberry pi, pi2, pi3 and pi4))
- __Mac OS__ (Many thanks to __zenlc2000__ for testing this on Mac OS 10.11)

### Requirements: ###
- __Python__ 3.6 or higher
- __Packages__ ( install them with: `pip install -r requirements.txt` ):
  - hy
  - psutil
  - pyte
  - PyQt6 (or PyQt5)
  - QScintilla
  - fpdf2
  - ptyprocess (Linux only)
  - pywin32 (Windows only)
  - pywinpty (Windows only)
