# Unit 02 CSS and Bootstrap Homework: Responsive Portfolio

Responsive design ensures that web applications render well on a variety of devices and window or screen sizes. As a developer, you will likely be asked to create a mobile-first application or add responsive design to an existing application. 

## Directions

1.	Use the Bootstrap CSS Framework to create a mobile responsive portfolio. How do you deliver this? 
2.	Create the following files files: 
<!-- a.	`index.html`
b.	`portfolio.html`
c.	`contact.html` -->
3.	Using Bootstrap, develop your portfolio site with the following items
a.	A navbar
b.	A responsive layout
c.	Responsive images
The Bootstrap portfolio should minimize the use of media queries.
### Hints
1.	* Use Bootstrap's grid system (containers, rows, and columns).
2.	* On an `xs` screen, content should take up the entire screen. On `sm` and larger screens, you should have some margins on the left and right sides of the screen. Check out various sites on your mobile device vs. your computer to see examples of these differences.
3.	Use an HTML validation service to ensure that each page has valid HTML.
	Extra small
<576px	Small
≥576px	Medium
≥768px	Large
≥992px	Extra large
≥1200px
.container	100%	540px	720px	960px	1140px
.container-sm	100%	540px	720px	960px	1140px
.container-md	100%	100%	720px	960px	1140px
.container-lg	100%	100%	100%	960px	1140px
.container-xl	100%	100%	100%	100%	1140px
.container-fluid	100%	100%	100%	100%	100%

### Minimum Requirements

o	 Functional, deployed application
o	 GitHub repository with README describing the project
o	 Navbar must be consistent on each page.
o	 Navbar on each page must contain links to Home/About, Contact, and Portfolio pages.
o	 All links must work.
o	 Must use semantic html.
o	 Each page must have valid and correct HTML. (use a validation service)
o	 Must contain your personalized information. (bio, name, images, links to social media, etc.)
o	 Must properly utilize Bootstrap components and grid system.

### Bonus
1.	 Using Bootstrap, make a sticky footer and use sub-rows and sub-columns on your portfolio site (**Hint:** Check out the Bootstrap documentation).
2.	## Commit Early and Often
3.	One of the most important skills to master as a web developer is version control. Building the habit of committing via Git is important for two reasons:
Your commit history
1.	is a signal to employers that you are actively working on projects and learning new skills.
2.	allows you to revert your codebase in the event that you need to return to a previous state.

Follow these guidelines for committing:
1.	* Make single-purpose commits for related changes to ensure a clean, manageable history. If you are fixing two issues, make two commits.

2.	* Write descriptive, meaningful commit messages so that you and anyone else looking at your repository can easily understand its history.
3.	* Don't commit half-done work, for the sake of your collaborators (and your future self!).
4.	* Test your application before you commit to ensure functionality at every step in the development process.
5.	We would like you to have well over 200 commits by graduation, so commit early and often!
## Submission on BCS
You are required to submit the following:
* The URLs of the deployed applications
	DOES THIS JUST MEAN THE URL FOR EACH html FILE?
* The URLs of the GitHub repositories

 
 
         

* Screenshots are provided as a reference in the `Assets/Images` folder. Your app does not need to be _exactly_ like the images. Use Bootstrap to create a similar, responsive layout.





C:\Users\jonpc\Google Drive\BootCamp\unc-chh-fsf-pt-03-2020-u-c\mathcodes.github.io\Homework\homework2\README.md
