/** @license
 *  Copyright 2016 - present The Material Motion Authors. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may not
 *  use this file except in compliance with the License. You may obtain a copy
 *  of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 *  License for the specific language governing permissions and limitations
 *  under the License.
 */

import { expect, use as useInChai } from 'chai';
import * as sinonChai from 'sinon-chai';
useInChai(sinonChai);

import {
  beforeEach,
  describe,
  it,
} from 'mocha-sugar-free';

import {
  stub,
} from 'sinon';

import {
  MemorylessIndefiniteSubject,
} from '../observables/MemorylessIndefiniteSubject';

import {
  subscribe,
} from '../subscribe';

describe('subscribe',
  () => {
    it('should return a subscription when sink is passed in',
      () => {
        const subscription = subscribe({
          sink: new MemorylessIndefiniteSubject(),
          source: new MemorylessIndefiniteSubject(),
        });

        expect(subscription.unsubscribe).to.exist;
      }
    );

    it('should return an array of subscriptions when an array of sinks is passed in',
      () => {
        const subscriptions = subscribe({
          sinks: [
            new MemorylessIndefiniteSubject(),
            new MemorylessIndefiniteSubject(),
          ],
          source: new MemorylessIndefiniteSubject(),
        });

        expect(subscriptions[0].unsubscribe).to.exist;
        expect(subscriptions[1].unsubscribe).to.exist;
      }
    );
  }
);
