
#ifndef sodium_H
#define sodium_H

#include "sodium_version.h"
#include "sodium_core.h"
#include "sodium_crypto_aead_chacha20poly1305.h"
#include "sodium_crypto_aead_xchacha20poly1305.h"
#include "sodium_crypto_auth.h"
#include "sodium_crypto_auth_hmacsha512.h"
#include "sodium_crypto_auth_hmacsha512256.h"
#include "sodium_crypto_box.h"
#include "sodium_crypto_box_curve25519xsalsa20poly1305.h"
#include "sodium_crypto_core_hsalsa20.h"
#include "sodium_crypto_core_hchacha20.h"
#include "sodium_crypto_core_salsa20.h"
#include "sodium_crypto_core_salsa2012.h"
#include "sodium_crypto_core_salsa208.h"
#include "sodium_crypto_generichash.h"
#include "sodium_crypto_generichash_blake2b.h"
#include "sodium_crypto_hash.h"
#include "sodium_crypto_hash_sha512.h"
#include "sodium_crypto_kx.h"
#include "sodium_crypto_onetimeauth.h"
#include "sodium_crypto_onetimeauth_poly1305.h"
#include "sodium_crypto_scalarmult.h"
#include "sodium_crypto_scalarmult_curve25519.h"
#include "sodium_crypto_secretbox.h"
#include "sodium_crypto_secretbox_xsalsa20poly1305.h"
#include "sodium_crypto_secretstream_xchacha20poly1305.h"
#include "sodium_crypto_shorthash.h"
#include "sodium_crypto_shorthash_siphash24.h"
#include "sodium_crypto_sign.h"
#include "sodium_crypto_sign_ed25519.h"
#include "sodium_crypto_stream.h"
#include "sodium_crypto_stream_chacha20.h"
#include "sodium_crypto_stream_salsa20.h"
#include "sodium_crypto_stream_xsalsa20.h"
#include "sodium_crypto_verify_16.h"
#include "sodium_crypto_verify_32.h"
#include "sodium_crypto_verify_64.h"
#include "sodium_randombytes.h"
#include "sodium_randombytes_salsa20_random.h"
#include "sodium_randombytes_sysrandom.h"
#include "sodium_runtime.h"
#include "sodium_utils.h"

#endif
