---
date-published: 2017-03-25T00:00:00Z
title: Making Remote Work
uuid: a658e901-04ec-4ff4-a2d5-c8c72231e3e7
permalink: /posts/making-remote-work.html
og-image: /images/selfies/2.jpg
type: post
---

I've been working remotely for a bit over a year now. Most projects went pretty well. Some not so much. I've worked with fully distributed teams and as a satellite worker with on-site teams. I'm not an expert—but I've learned some things.

What follows are some basic ideas to make remote teams work. I hope these help companies and remote workers set things up for success.

### Focus on Self Sufficiency 

In an office you walk up to somebody (read: interrupt their work) and discuss stuff. In a remote environment you may need to schedule, then wait, then deal with connectivity issues, then have a discussion. Sometimes the waiting part alone can take the better part of a day.

Synchronous communication, including chat, is great and necessary but the more your work routine relies on it, the more you might unknowingly slow everyone down.

With that in mind, start thinking of communication as a cost factor. Being slowed down costs time, momentum and motivation. These are the things you usually want to preserve at all cost. And that's where self-sufficiency comes in.

Being self sufficient in work means knowing what to do in order to advance the project and having the means to execute. The easiest way to make people understand what is worth working on is making them understand the business. Sometimes more specific goals will also do the job. But generally the broader the better.

Once everyone is able to develop ideas based on their understanding of the business all that is missing is The Feedback Loop™. Feedback is often a critical part of UI design but that does not mean it isn't applicable to other domains. Enable your team to see the impact of their work. Define relevant metrics and measure, measure, measure, graph, graph, graph. Share and celebrate accomplishments.


### Document With Rigour 

Again, communication has a cost. It's fun and important too. You want to spend that valuable face-time with your colleagues chatting about last weekends hike or that tricky problem you're banging your head against. You don't want to spend it figuring out how to run migrations or update your environment so that things work again with those latest changes.

Have a `README`. Make sure to add a table of contents. This is reference material, not an essay. Maybe try Asciidoc if Markdown feels too restrictive. Ensure that pull requests are reviewed with documentation changes in mind. With GitHub's pull request templates it's easy to remind team members to update documentation.

That hike last week was nice by the way:

![](/images/hike.jpg)

<div class="pa2 tc f3 blue">·  ·  ·</div>

I realize the up-front cost of making someone understand the intricacies of a business might be higher than just telling them to "do this". There may be smaller projects where deep understanding is not necessary. It seems reasonable to think that everyone does a better job if they do understand the business though.

Now all these suggestions are probably applicable to any team, not only remote ones. However they are of particular importance for remote teams.

<p class="f6 ba br2 b--blue pa3 mt4">Distributed teams face special challenges. <a href="https://goo.gl/forms/BTteLFXQFopWOXxt1">I would love to hear yours</a> and see if there might be something that could be built to help.</p>
