---
date-published: 2015-07-24T00:00:00Z
title: ClojureBridge Berlin
uuid: 3264b651-0aac-4e62-8751-77b88828f856
permalink: /posts/clojurebridge-berlin.html
og-image: /images/selfies/3.jpg
type: post
---

About two weeks ago something awesome happened: the very first
ClojureBridge workshop in Berlin. After months of planning things
finally got real.

![ClojureBridge Berlin in it's entirety.](/images/clojurebridge-group-picture.jpg)

> ClojureBridge aims to increase diversity within the Clojure
> community by offering free, beginner-friendly Clojure programming
> workshops for women.

Many of you probably got the *"news"*: there's a lack of diversity in
programming communities. Many communities acknowledge this and have
created initiatives to fix it. The Ruby community has RailsBridge (and
more) and other communties equally do their part in improving our
industries diversity situation. Inspired by RailsBridge the Clojure
community established ClojureBridge and has organized more than 20
workshops worldwide since.

### Why Diversity?

There are
[endless amounts](http://www.ncwit.org/sites/default/files/resources/impactgenderdiversitytechbusinessperformance_print.pdf)
[of research](http://newsoffice.mit.edu/2014/workplace-diversity-can-help-bottom-line-1007)
why diversity is desirable but one of the reasons that seems most
intuitive to me is that software is, after all, for humans. If we want
to make great software for everyone then it can only be made by all of
us and not by one priviliged monoculture.

### ClojureBridge Berlin

ClojureBridge workshops consist of one evening installing required
software (Friday) and a full day of actually learning things
(Saturday). Besides some problems with our pizza delivery both days
went really well. We had great vegan and vegetarian lunch on Saturday,
fun ClojureBridge cupcakes and after the coffee machine broke on Friday
people brought lots of coffee making equipment to the event on Saturday.
You could say we had a little
[third wave coffee](https://en.wikipedia.org/wiki/Third_wave_of_coffee)
workshop as well.

![We got some sweet cupcakes!](/images/clojurebridge-cupcakes.jpg)

On Saturday we initially had 2-3 coaches that "didn't have a job" and
we were afraid they might feel superflous but the need for some
additional help quickly arised when some learners got ahead of the
rest of their group. In the end we were very happy that we had the
flexibility of not having assigned all coaches to groups. (We still
had teaching assistants.)

### Results

At the end of the event we had a fantastic demo time. A great amount
of learners showed their Quil creations, from an Santa Claus to
stroboscopic rainbow animations. It was great to see how in the
beginning everyone was shy to show their work but as more people did
others felt encouraged to do the same.

### Takeaways

This was the first time we organized such workshop in Berlin. We were
lucky to be a big team of organizers (six people) which allowed us to
distribute the work.

The feedback we got during and after the workshop has been very
positive. About a third of the attendees have registered interest in
joining project groups to keep learning. Obviously the more the better
but even ten people is a nice outcome overall.

### Thanks

I'd like to take the opportunity to thank all of our coaches: Nils,
Sean, Paulus, Jan, Johannes, Ben, Franziska, Luca, Txus, Kofi,
Torsten, Tibor, Thomas, Stephan, Oskar, Kai & Matt thank you so much
for being part of this. **None of it would have happened without you!**

Also I'd like to thank my fellow organizers for pushing through the
finish line together and for just being an overall awesome
bunch. Thanks Bettina, Malwine, Arne, Jelle & Nicola.

Last but not least I'd like to thank the companies that enabled
ClojureBridge Berlin: Wunderlist, SoundCloud, GitHub, InnoQ,
TicketSolve, Babbel & DaWanda. A special thank you in this regard to
Andrei, who has done an exceptional job at hosting the event at
Wunderlist!

![ClojureBridge Berlin T-Shirts](/images/clojurebridge-shirts.jpg)

If you'd like to be informed about upcoming workshops, follow
[@ClojureBerlin](https://twitter.com/clojureberlin) on Twitter. If you
don't have Twitter you can also
 [send me an email](mailto:martinklepsch@googlemail.com) and I'll make
 sure you'll be notified
:-)

<aside>
<p>Image credits (in order):
 <a href="https://twitter.com/bumbledebee">@bumbledebee</a>,
 <a href="https://twitter.com/codebeige/status/619804392284422144">@codebeige</a>,
 <a href="https://twitter.com/ClojureBerlin/status/619890238584963072">@malwine</a>.</p>
</aside>
