---
date-published: 2013-04-25T00:00:00Z
title: Asynchronous Communication
uuid: d3811416-0031-4a02-8578-521a4540f889
permalink: /posts/asynchronous-communication.html
og-image: /images/selfies/3.jpg
type: post
---
Communication is a central part of working in teams.
I believe having asynchronous communication channels and making heavy use of them can have
great effects on productivity, transparency and therefore happiness and fun within teams.
Here are a few reasons why.

## Interruptions

There are [dozens of studies](http://www.nytimes.com/2007/03/25/business/25multi.html)
about the consequences of being interrupted while performing demanding tasks. They usually
suggest that it takes a human around 20 minutes to get back into the state they have been in
prior to the interruption. As if this wouldn't be enough it also increases the chances of
making mistakes.

While a chatroom doesn't necessarily removes interruptions all at once it
allows everyone to react to an interruption at will. If you really want no interruption for
a certain period of time you can easily turn off all notifications.
Not reacting to the waving hands of a coworker is quite a bit harder (and not very polite as
well).

## Transparency

Transparency is a great thing. I strongly believe an absolutistic approach to transparency
is the only way to go nowadays. Transparency helps to identify bad decisions early on and
increases acceptance of decisions by keeping everyone in the loop. Companies like
[Stripe](https://stripe.com/blog/email-transparency) are doing an excellent job at
advocating this approach. I could go into lengths about how important this is.

Achieving this level of transparency with meetings and written reports is very time
consuming if not impossible at all. Channeling most communication through asynchronous
communication channels allows other people to passively follow along and saves a bunch
of time that would otherwise have been spent in inefficient meetings.

## Written Communication

Think before you speak. That's what they say. Problem is that this is quite hard in a fast
paced environment like meetings. Just taking 5 minutes to order your thoughts isn't
something people usually do there. Instead they talk. Written communication forces you to
get to the point in a way that everyone can follow and at the same time allows you to refine
your own understanding of the problem.

## Tool Integration

Most of the team chat things you'll find provide integrations with your existing toolchain.
It's easy to setup a bot that notifies you about breaking builds, new commits, errors on
your platform or whatever else. Integrating this kind of information into your communication
channels allows better collaboration on it and also increases visibility of what people are
working on (= transparency).

## Logging

In my experience things are often discussed in passing and sometimes even decisions are made
in these situations. A week later when you actually find the time to implement the things
decided back then they seem stupid and you are not able to actually retrieve the reasoning
behind them from the back of your head. Having in place the infrastructure to quickly
discuss something without setting up a meeting is a great way to avoid this kind of decision
making and also allows you to trace back past discussions if a decision is being questioned.

## Location-independent Productivity

Channeling most conversation through chat rooms makes team members less dependent on being
geographically close to each other. (I'm not expanding on this as I think removing
a dependency is always a good thing.)

## Closing Remarks & Further Reading

I'm a strong believer when it comes to asynchronous communication and I hope this list
provides a good overview about the main reasons why it's a good approach to internal
communication.

* [Chat Trumps Meetings](http://zachholman.com/posts/chat/) by Zach Holman
* [How Github Works Asynchronous](http://zachholman.com/posts/how-github-works-asynchronous/) by Zach Holman
* [Stripes Culture](http://blog.alexmaccaw.com/stripes-culture) by Alex MacCaw
* [How Stripe Builds Software](http://blog.alexmaccaw.com/stripes-culture) with Greg Brockmann
