---
date-published: 2012-01-28T00:00:00Z
title: Exim4 Fix Wrongly Decoded Mail Subject
uuid: 6ff5c174-6f89-4449-9a6c-2315bedaed33
permalink: /posts/fix-broken-decoding-of-mail-subjects-in-exim.html
og-image: /images/selfies/3.jpg
hidden: true
type: post
---

If you are using [Exim](http://www.exim.org/) to transfer mails generated by internal software you probably often get
mails with a really weird looking subject that starts with something like this:

    =?utf-8?Q?=5BPersonalverwaltung_=2D_Fehler_=23=31=37=38=5D_...


This problem arises when some system sends an email with **more than 76 characters in the subject line** (usually people don't do that).

> While there is no limit to the length of a multiple-line header field,
> each line of a header field that contains one or more
> encoded-word's is limited to 76 characters.
>
> The length restrictions are included both to ease interoperability
> through internetwork mail gateways, and to impose a limit on the
> amount of lookahead a header parser must employ (while looking for a
> final ?= delimiter) before it can decide whether a token is an
> "encoded-word" or something else.
>
> <cite>Excerpt from <a href="http://www.ietf.org/rfc/rfc2047.txt">RFC2047</a></cite>


## Fix It

You can remove the length checking by adding the following to the main section of your
`/etc/exim4/exim4.conf`. The main section usually ends with the first `begin` in that file.

    check_rfc2047_length = false

For further reference I recommend the official [Exim documentation](http://www.exim.org/exim-html-current/doc/html/spec_html/ch14.html)
