---
title: Mobile First Constraints
date-published: 2021-02-16T08:27:11.989Z
uuid: d80a3ffa-30de-40c8-84a5-b0a9857100c4
og-image: /images/selfies/2.jpg
type: onehundred
permalink: /100/mobile-first-constraints.html
---
I've been revisiting a book on [Mobile First](https://www.lukew.com/resources/mobile_first.asp) over the last couple of days. It's a very short and sweet book, like many others by [A Book Apart](https://abookapart.com/). The book argues that web experiences should be designed for mobile first for two main reasons: 

1. mobile is growing like hell and 
2. starting with a more constrained design leads to a better understanding of the core of what is being built. 

The case for mobile growing is supported by engagement and screen time metrics with a kind of blissful ignorance for more recent addiction concerns that you can probably only find in a 2015 book.

Anyways, that second point is what stayed with me and what I've been thinking about a lot in the context of my own work. Designing for mobile first, forces a product team to discover the essence of a feature that is being developed. It becomes about identifying the smallest useful thing to ship. 

If you think about it there aren't any quite as easy-to-articulate constraints to be a forcing function. Most of the reduction happening in the product development process is based on intuition, subjective experience and user interviews. Designing for a small screen first on the other hand is an incredibly specific guideline.

It also reinforces all the things I want when working on product stuff: learning from experiments as early as possible and shipping fast / building momentum.

To end this, here's a nice quote from [Kate Aronowitz](https://twitter.com/katearonowitz), back then Facebook’s Director of Design:

> We’re just now starting to get into mobile first and then web second for a lot of our products. What we’re finding is that the designers on mobile are really embracing the constraints \[and] that it’s actually teaching us a lot about how to design back to the desktop,
