---
title: How do you get a remote Clojure job?
date-published: 2021-02-16T17:01:26.181Z
uuid: e3aefa0b-1858-4fe8-9553-534b842ad209
og-image: /images/selfies/2.jpg
type: onehundred
permalink: /100/how-do-you-get-a-remote-clojure-job.html
---
I don't think there's a significant difference to getting any other remote job. In the end Clojure is a programming language and the ways you show you're qualified feel largely similar (with some aspects being more top-of-mind in individual communities). Also keep in mind that many roads lead to Rome and that my perspective on this isn't going to be an absolute truth but rather something that grew from my experiences. Yours might be different and the path of least resistance is always to find out what works best for you.

📝  Write code, put it out there and allow people to trace your decision making. Architecture Decision Records (ADRs) are something that I found helpful in this regard. Often people do this in the form of libraries but I don't think it really matters if others use the code in the end. Maybe the code you're most excited about writing is a little application to scratch a personal itch. 

👩🏽‍💻 Network. I hate this term personally and it has never felt like what I've been doing but I've been active in local meetups, conferences and online communities, which has made me many friends and access to several opportunities that were never listed on a job board.

👀 Nonetheless, keep an eye out for remote job listings. Identify themes in what companies are looking for, reflect on which opportunities excite you and which don't. Invest in skills that you feel you might be lacking for the exciting ones. 

💪 If something looks exciting but you don't have the requested experience/skills, reach out anyways. Likely you'll learn something from that interaction and often people are willing to take chances with you if they can sense your excitement. At the very least you've put yourself on the map for them.

💰 Start cheap. This kind of depends on your other experience obviously but if you want to transition (e.g. to being remote or writing Clojure), getting the first job locked in is the hardest. Reducing your rate can make this easier and you can always renegotiate or try to find a second job, that is willing to pay better. I once read that people who change jobs more often tend to earn more money, which seems logical to me given the competitive dynamics around hiring + the incentive to keep operating expenses low. (For context I should say that I've worked as a freelancer for a long time.)

✍🏻 Write and get better at it. Remote work tends to be much more asynchronous and writing is a key skill to be an efficient collaborator. People hiring for remote roles will want to judge your writing skills. If you're not a native English speaker don't let that deter you. While grammatical correctness is nice it is not the most important thing as long as things are understandable. What is important is making the complex simple ;) Often the goal is building consensus or transferring knowledge (a.k.a. documentation). Identify what goal you have with a piece of writing and find the right structure to achieve it. A blog can be a great venue to practice and showcase your writing. (A blog can be a plain GitHub repo.)

Hope this helps! 

PS. I realize that a lot of these things require time and not everyone may have the luxury of a lot of free time. If you're a member of an underrepresented group and feel like a bit of cash would go a long way in terms of making time for the things above, send me a DM.

*Note: This was originally posted [on rep.ly](https://rep.ly/answer/5f92959f17801d0018370de4).*