require "./app"
require "./auth/**"

module Marten
  module CLI
    module Templates
      module Auth
        def self.app_files(context : App::Context)
          [
            {"app.cr", ECR.render("#{__DIR__}/auth/templates/app/app.cr.ecr")},
            {"cli.cr", ECR.render("#{__DIR__}/auth/templates/app/cli.cr.ecr")},
            {"routes.cr", ECR.render("#{__DIR__}/auth/templates/app/routes.cr.ecr")},
            {
              "emails/password_reset_email.cr",
              ECR.render("#{__DIR__}/auth/templates/app/emails/password_reset_email.cr.ecr"),
            },
            {
              "handlers/concerns/require_anonymous_user.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/handlers/concerns/require_anonymous_user.cr.ecr",
              ),
            },
            {
              "handlers/concerns/require_signed_in_user.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/handlers/concerns/require_signed_in_user.cr.ecr"
              ),
            },
            {
              "handlers/password_reset_confirm_handler.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/handlers/password_reset_confirm_handler.cr.ecr"
              ),
            },
            {
              "handlers/password_reset_initiate_handler.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/handlers/password_reset_initiate_handler.cr.ecr"
              ),
            },
            {
              "handlers/password_update_handler.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/handlers/password_update_handler.cr.ecr"
              ),
            },
            {
              "handlers/profile_handler.cr",
              ECR.render("#{__DIR__}/auth/templates/app/handlers/profile_handler.cr.ecr"),
            },
            {
              "handlers/sign_in_handler.cr",
              ECR.render("#{__DIR__}/auth/templates/app/handlers/sign_in_handler.cr.ecr"),
            },
            {
              "handlers/sign_out_handler.cr",
              ECR.render("#{__DIR__}/auth/templates/app/handlers/sign_out_handler.cr.ecr"),
            },
            {
              "handlers/sign_up_handler.cr",
              ECR.render("#{__DIR__}/auth/templates/app/handlers/sign_up_handler.cr.ecr"),
            },
            {
              "migrations/0001_create_#{context.label}_user_table.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/migrations/0001_create_auth_user_table.cr.ecr"
              ),
            },
            {
              "models/user.cr",
              ECR.render("#{__DIR__}/auth/templates/app/models/user.cr.ecr"),
            },
            {
              "schemas/password_reset_confirm_schema.cr",
              ECR.render("#{__DIR__}/auth/templates/app/schemas/password_reset_confirm_schema.cr.ecr"),
            },
            {
              "schemas/password_reset_initiate_schema.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/schemas/password_reset_initiate_schema.cr.ecr"
              ),
            },
            {
              "schemas/password_update_schema.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/app/schemas/password_update_schema.cr.ecr"
              ),
            },
            {
              "schemas/sign_in_schema.cr",
              ECR.render("#{__DIR__}/auth/templates/app/schemas/sign_in_schema.cr.ecr"),
            },
            {
              "schemas/sign_up_schema.cr",
              ECR.render("#{__DIR__}/auth/templates/app/schemas/sign_up_schema.cr.ecr"),
            },
            {
              "templates/#{context.label}/emails/password_reset.html",
              ECR.render(
                "#{__DIR__}/auth/templates/app/templates/emails/password_reset.html.ecr"
              ),
            },
            {
              "templates/#{context.label}/password_reset_confirm.html",
              ECR.render(
                "#{__DIR__}/auth/templates/app/templates/password_reset_confirm.html.ecr"
              ),
            },
            {
              "templates/#{context.label}/password_reset_initiate.html",
              ECR.render(
                "#{__DIR__}/auth/templates/app/templates/password_reset_initiate.html.ecr"
              ),
            },
            {
              "templates/#{context.label}/password_update.html",
              ECR.render(
                "#{__DIR__}/auth/templates/app/templates/password_update.html.ecr"
              ),
            },
            {
              "templates/#{context.label}/profile.html",
              ECR.render("#{__DIR__}/auth/templates/app/templates/profile.html.ecr"),
            },
            {
              "templates/#{context.label}/sign_in.html",
              ECR.render("#{__DIR__}/auth/templates/app/templates/sign_in.html.ecr"),
            },
            {
              "templates/#{context.label}/sign_up.html",
              ECR.render("#{__DIR__}/auth/templates/app/templates/sign_up.html.ecr"),
            },
          ]
        end

        def self.spec_files(context : App::Context)
          spec_helper_inner = ECR.render("#{__DIR__}/auth/templates/spec/spec_helper_inner.cr.ecr")
          spec_helper_outer = ECR.render("#{__DIR__}/auth/templates/spec/spec_helper_outer.cr.ecr")

          [
            {
              "apps/#{context.label}/emails/password_reset_email_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/emails/password_reset_email_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/emails/spec_helper.cr",
              spec_helper_inner,
            },
            {
              "apps/#{context.label}/handlers/concerns/require_anonymous_user_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/handlers/concerns/require_anonymous_user_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/handlers/concerns/require_signed_in_user_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/handlers/concerns/require_signed_in_user_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/handlers/concerns/spec_helper.cr",
              spec_helper_inner,
            },
            {
              "apps/#{context.label}/handlers/password_reset_confirm_handler_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/handlers/password_reset_confirm_handler_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/handlers/password_reset_initiate_handler_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/handlers/password_reset_initiate_handler_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/handlers/password_update_handler_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/handlers/password_update_handler_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/handlers/profile_handler_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/handlers/profile_handler_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/handlers/sign_in_handler_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/handlers/sign_in_handler_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/handlers/sign_out_handler_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/handlers/sign_out_handler_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/handlers/sign_up_handler_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/handlers/sign_up_handler_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/handlers/spec_helper.cr",
              spec_helper_inner,
            },
            {
              "apps/#{context.label}/spec_helper.cr",
              spec_helper_outer,
            },
            {
              "apps/#{context.label}/schemas/password_reset_confirm_schema_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/schemas/password_reset_confirm_schema_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/schemas/password_reset_initiate_schema_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/schemas/password_reset_initiate_schema_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/schemas/password_update_schema_spec.cr",
              ECR.render(
                "#{__DIR__}/auth/templates/spec/schemas/password_update_schema_spec.cr.ecr"
              ),
            },
            {
              "apps/#{context.label}/schemas/sign_in_schema_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/schemas/sign_in_schema_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/schemas/sign_up_schema_spec.cr",
              ECR.render("#{__DIR__}/auth/templates/spec/schemas/sign_up_schema_spec.cr.ecr"),
            },
            {
              "apps/#{context.label}/schemas/spec_helper.cr",
              spec_helper_inner,
            },
          ]
        end
      end
    end
  end
end
