---
title: Marten 0.2.0 release notes
pagination_prev: null
pagination_next: null
---

_February 11, 2023._

## Requirements and compatibility

Crystal 1.6 and 1.7.

## New features

### Authentication

The framework now provides the ability to generate projects with a [built-in authentication system](../../authentication.mdx) that handles basic user management needs: signing in/out users, resetting passwords, etc. This can be achieved through the use of the `--with-auth` option of the [`new`](../../development/reference/management-commands.md#new) management command:

```bash
marten new project myblog --with-auth
```

The `--with-auth` option ensures that an `auth` [application](../../development/applications.md) is created for the generated project under the `src/auth` folder. This application is part of the created project and provides the necessary [models](../../models-and-databases.mdx), [handlers](../../handlers-and-http.mdx), [schemas](../../schemas.mdx), [emails](../../emailing.mdx), and [templates](../../templates.mdx) allowing authenticating users with email addresses and passwords, while also supporting standard password reset flows. All these abstractions provide a "default" authentication implementation that can be then updated on a per-project basis to better accommodate authentication-related requirements.

### Email sending

Marten now lets you define [emails](../../emailing.mdx) that you can fully customize (properties, header values, etc) and whose bodies (HTML and/or text) are rendered by leveraging [templates](../../templates.mdx). For example, here is how to define a simple email and how to deliver it:

```crystal
class WelcomeEmail < Marten::Email
  to @user.email
  subject "Hello!"
  template_name "emails/welcome_email.html"

  def initialize(@user : User)
  end
end

email = WelcomeEmail.new(user)
email.deliver
```

Emails are delivered by leveraging an [emailing backend mechanism](../../emailing/introduction.md#emailing-backends). Emailing backends implement _how_ emails are actually sent and delivered. Presently, Marten supports one built-in [development emailing backend](../../emailing/reference/backends.md#development-backend), and a set of other [third-party backends](../../emailing/reference/backends.md#other-backends) that you can install depending on your email sending requirements.

Please refer to the [Emailing section](../../emailing.mdx) to learn more about this new feature.

### Raw SQL capabilities

Query sets now provide the ability to perform raw queries that are mapped to actual model instances. This is interesting if the capabilities provided by query sets are not sufficient for the task at hand and you need to write custom SQL queries.

For example:

```crystal
Article.raw("SELECT * FROM articles WHERE title = ?", "Hello World!").each do |article|
  # Do something with `article` record
end
```

Please refer to [Raw SQL](../../models-and-databases/raw-sql.md) to learn more about this capability.

### Email field for models and schemas

It is now possible to define `email` fields in [models](../../models-and-databases/reference/fields.md#email) and [schemas](../../schemas/reference/fields.md#email). These allow you to easily persist valid email addresses in your models but also to expect valid email addresses in data validated through the use of schemas.

For example:

```crystal
class User < Marten::Model
  field :id, :big_int, primary_key: true, auto: true
  field :email, :email, unique: true
end
```

### Transaction callbacks

Models now support the definition of transaction callbacks by using the [`#after_commit`](../../models-and-databases/callbacks.md#after_commit) and [`#after_rollback`](../../models-and-databases/callbacks.md#after_rollback) macros.

For example:

```crystal
class User < Marten::Model
  field :id, :big_int, primary_key: true, auto: true
  field :username, :string, max_size: 64, unique: true

  after_commit :do_something, on: :update

  private def do_something
    # Do something!
  end
end
```

Please refer to [Callbacks](../../models-and-databases/callbacks.md) to learn more about this capability.

### Minor features

#### Models and databases

* Support for [DB connection pool parameters](https://crystal-lang.org/reference/database/connection_pool.html) was added. See the [database settings reference](../../development/reference/settings.md#database-settings) for more details about the supported parameters
* Model fields now contribute `#<fieldName>?` methods to model classes in order to easily identify if a field has a value or not. Note that this capability is also enabled for the relationship methods provided by the [`many_to_one`](../../models-and-databases/reference/fields.md#many_to_one) and [`one_to_one`](../../models-and-databases/reference/fields.md#one_to_one) fields
* It is now possible to leverage a [`#with_timestamp_fields`](pathname:///api/0.2/Marten/DB/Model/Table.html#with_timestamp_fields-macro) macro to automatically create `created_at` / `updated_at` timestamp fields in models. The `created_at` field is populated with the current time when new records are created while the `updated_at` field is refreshed with the current time whenever records are updated. See [Timestamps](../../models-and-databases/introduction.md#timestamps) to learn more about this capability
* It is now possible to easily retrieve specific column values without loading entire record objects by leveraging the [`#pluck`](../../models-and-databases/reference/query-set.md#pluck) and [`#pick`](../../models-and-databases/reference/query-set.md#pick) query set methods

#### Handlers and HTTP

* `string` can now be used as an alias for `str` when defining [routing parameters](../../handlers-and-http/routing.md#specifying-route-parameters)

#### Templates

* Support for index lookups was added. This means that it is now possible to retrieve specific index values from indexable objects in templates using the `{{ var.<index> }}` syntax (for example: `{{ var.0 }}`)
* A [`linebreaks`](../../templates/reference/filters.md#linebreaks) template filter was introduced to allow replacing all newlines with HTML line breaks (`<br />`) in strings easily

#### Schemas

* Schemas can now be initialized from handler routing parameters (which means that they can be initialized from the hashes that are returned by the [`Marten::Handlers::Base#params`](pathname:///api/0.2/Marten/Handlers/Base.html#params%3AHash(String%2CInt16|Int32|Int64|Int8|String|UInt16|UInt32|UInt64|UInt8|UUID)-instance-method) method)

#### Management commands

* The [`serve`](../../development/reference/management-commands.md#serve) management command now supports the ability to override the host and port used by the development server

#### Testing

* A [testing client](../../development/testing.md#using-the-test-client) was introduced in order to allow developers to easily test handlers (and the various routes of a project) by issuing requests and by introspecting the returned responses.

## Backward incompatible changes

### Templates

* The `loop.first` and `loop.last` for loop variables were respectively renamed `loop.first?` and `loop.last?`. See the [template tag reference](../../templates/reference/tags.md#for) to learn more about the `for` template tag

### Management commands

* The [`new`](../../development/reference/management-commands.md#new) management command's optional directory argument was replaced by a dedicated `-d DIR, --dir=DIR` option
