---
title: Marten 0.6.0 release notes
pagination_prev: null
pagination_next: null
---

_Under development._

## Requirements and compatibility

* **Crystal:** 1.12, 1.13, and 1.14.
* **Databases:**
  * MariaDB 10.4 and higher.
  * MySQL 8.0.11 and higher.
  * PostgreSQL 12 and higher.
  * SQLite 3.27.0 and higher.

## New features

### Minor features

#### Models and databases

* [Query sets](../../models-and-databases/queries.md) now support XOR operations when [performing complex queries involving `q` expressions](../../models-and-databases/queries.md#complex-filters-with-q-expressions). Additionally, combining query sets using the XOR operator (`^`) is now also supported (see [`#^ (XOR)`](../../models-and-databases/reference/query-set.md#-xor)).
* A new [`slugify`](../../models-and-databases/reference/fields.md#slugify) option was added to [`slug`](../../models-and-databases/reference/fields.md#slug) model fields in order to make it possible to automatically generate a slug value from another local model field.
* Query pages (instances of [`Marten::DB::Query::Page`](pathname:///api/dev/Marten/DB/Query/Page.html)) now expose a [`#pages_count`](pathname:///api/dev/Marten/DB/Query/Page.html#pages_count-instance-method) method that allows to get the total number of pages.
* Related objects are now automatically loaded when accessing backward relations (such as backward many-to-one relations or backward one-to-one relations).
* The ability to retrieve specific records by using raw SQL predicates was introduced. See [Fetching single records with raw SQL predicates](../../models-and-databases/raw-sql.md#fetching-single-records-with-raw-sql-predicates) to learn more about this new capability.

#### Handlers and HTTP

* [Session stores](../../handlers-and-http/sessions.md) now make it possible to easily configure when session entries expire through the use of the [`#expires_at=`](pathname:///api/dev/Marten/HTTP/Session/Store/Base.html#expires_at%3D(value%3ATime)-instance-method), [`#expires_at_browser_close=`](pathname:///api/dev/Marten/HTTP/Session/Store/Base.html#expires_at_browser_close%3D(value%3ABool)-instance-method), and [`#expires_in=`](pathname:///api/dev/Marten/HTTP/Session/Store/Base.html#expires_in%3D(value%3ATime%3A%3ASpan)-instance-method) methods. Please refer to [Customizing session expiry times](../../handlers-and-http/sessions.md#customizing-session-expiry-times) to learn more about this capability.
* An alias for the [`#reverse`](pathname:///api/dev/Marten/Handlers/Base.html#reverse(*args%2C**options)-instance-method) handler method ([`#url`](pathname:///api/dev/Marten/Handlers/Base.html#url(name%3AString|Symbol%2C**kwargs)%3AString-instance-method)) was introduced.
* A [Referrer-Policy middleware](../../handlers-and-http/reference/middlewares.md#referrer-policy-middleware) was introduced to make it possible to automatically set the Referrer-Policy header in responses generated by handlers.
* A new [`unsupported_http_method_strategy`](../../development/reference/settings.md#unsupported_http_method_strategy) setting was introduced to make it possible to configure the strategy to use when processing unsupported HTTP methods in handlers. This setting can be used to configure whether such requests should result in 405 Method Not Allowed responses (the default behavior) or 404 Not Found responses.
* It is now possible to use any hash or named tuple to define schema initial data in handlers that use subclasses of [`Marten::Handlers::Schema`](pathname:///api/dev/Marten/Handlers/Schema.html) (in the [`#initial_data`](pathname:///api/dev/Marten/Handlers/Schema.html#initial_data-instance-method) method).

#### Templates

* A new [`localize`](../../templates/reference/tags.md#localize) template tag was introduced to make it easy to localize values (such as dates, numbers, and time values) within templates.
* An alias for the [`url`](../../templates/reference/tags.md#url) template tag ([`reverse`](../../templates/reference/tags.md#reverse)) was introduced.

#### Schemas

* The [`date`](../../schemas/reference/fields.md#date) and [`date_time`](../../schemas/reference/fields.md#date_time) schema fields now fall back to the formats specified in the [`date_input_formats`](../../development/reference/settings.md#date_input_formats) and [`date_time_input_formats`](../../development/reference/settings.md#date_time_input_formats) settings, respectively, when localized formats fail to parse raw field values.

#### Development

* A new `--log-level` command option was introduced to make it easier to configure the log level to use when running [management commands](../../development/management-commands.md) (see [Shared options](../../development/management-commands.md#shared-options) for more details).
* The [`new`](../../development/reference/management-commands.md#new) management command now makes it possible to generate projects without configured databases when the `--database=none` option is used.
* Projects generated with the [`new`](../../development/reference/management-commands.md#new) management command now include the [Referrer-Policy middleware](../../handlers-and-http/reference/middlewares.md#referrer-policy-middleware) by default.
* The [`new`](../../development/reference/management-commands.md#new) management command now generates a `seed.cr` file when generating new project structures.
* A new [`seed`](../../development/reference/management-commands.md#seed) management command was introduced to make it easy to execute seed files.
* Log entries generated when running the development server ([`serve`](../../development/reference/management-commands.md#serve) management command) in debug mode now include more details about processed requests, rendered templates, and executed SQL queries.
* Database configuration now supports connection strings, which can be useful in scenarios where only a connection string is provided (e.g., via a `DATABASE_URL` environment variable from cloud providers). See [Database settings](../../development/reference/settings.md#database-settings) to learn more about this new capability.
* New [`date_input_formats`](../../development/reference/settings.md#date_input_formats) and [`date_time_input_formats`](../../development/reference/settings.md#date_time_input_formats) settings were introduced to provide additional flexibility in parsing [`date`](../../schemas/reference/fields.md#date) and [`date_time`](../../schemas/reference/fields.md#date_time) schema field values. These settings allow you to define fallback input formats that are used when localized formats cannot successfully parse raw [`date`](../../schemas/reference/fields.md#date)/[`date_time`](../../schemas/reference/fields.md#date_time) schema field values.
