<?php

namespace MathPHP\SampleData;

/**
 * cereal dataset (Data from cereals - R chemometrics)
 * https://rdrr.io/cran/chemometrics/man/cereal.html
 *
 * For 15 cereals an X and Y data set, measured on the same objects, is available.
 * The X data are 145 infrared spectra, and the Y data are 6 chemical/technical properties (Heating value, C, H, N, Starch, Ash).
 * Also the scaled Y data are included (mean 0, variance 1 for each column).
 * The cereals come from 5 groups B=Barley, M=Maize, R=Rye, T=Triticale, W=Wheat.
 *
 * X:   15 rows and 145 columns
 * Y:   15 rows and 6 columns
 * Ysc: 15 rows and 6 columns
 *
 * Source: K. Varmuza and P. Filzmoser: Introduction to Multivariate Statistical Analysis in Chemometrics. CRC Press, Boca Raton, FL, 2009.
 */
class Cereal
{
    public const CEREALS = ['B1', 'B2', 'B3', 'M1', 'M2', 'M3', 'R1', 'R2', 'R3', 'T1', 'T2', 'T3', 'W1', 'W2', 'W3'];

    private const X_LABELS = ['X1126.0', 'X1134.0', 'X1142.0', 'X1150.0', 'X1158.0', 'X1166.0', 'X1174.0', 'X1182.0', 'X1190.0', 'X1198.0', 'X1206.0', 'X1214.0', 'X1222.0', 'X1230.0', 'X1238.0', 'X1246.0', 'X1254.0', 'X1262.0', 'X1270.0', 'X1278.0', 'X1286.0', 'X1294.0', 'X1302.0', 'X1310.0', 'X1318.0', 'X1326.0', 'X1334.0', 'X1342.0', 'X1350.0', 'X1358.0', 'X1366.0', 'X1374.0', 'X1382.0', 'X1390.0', 'X1398.0', 'X1406.0', 'X1414.0', 'X1422.0', 'X1430.0', 'X1438.0', 'X1446.0', 'X1454.0', 'X1462.0', 'X1470.0', 'X1478.0', 'X1486.0', 'X1494.0', 'X1502.0', 'X1510.0', 'X1518.0', 'X1526.0', 'X1534.0', 'X1542.0', 'X1550.0', 'X1558.0', 'X1566.0', 'X1574.0', 'X1582.0', 'X1590.0', 'X1598.0', 'X1606.0', 'X1614.0', 'X1622.0', 'X1630.0', 'X1638.0', 'X1646.0', 'X1654.0', 'X1662.0', 'X1670.0', 'X1678.0', 'X1686.0', 'X1694.0', 'X1702.0', 'X1710.0', 'X1718.0', 'X1726.0', 'X1734.0', 'X1742.0', 'X1750.0', 'X1758.0', 'X1766.0', 'X1774.0', 'X1782.0', 'X1790.0', 'X1798.0', 'X1806.0', 'X1814.0', 'X1822.0', 'X1830.0', 'X1838.0', 'X1846.0', 'X1854.0', 'X1862.0', 'X1870.0', 'X1878.0', 'X1886.0', 'X1894.0', 'X1902.0', 'X1910.0', 'X1918.0', 'X1926.0', 'X1934.0', 'X1942.0', 'X1950.0', 'X1958.0', 'X1966.0', 'X1974.0', 'X1982.0', 'X1990.0', 'X1998.0', 'X2006.0', 'X2014.0', 'X2022.0', 'X2030.0', 'X2038.0', 'X2046.0', 'X2054.0', 'X2062.0', 'X2070.0', 'X2078.0', 'X2086.0', 'X2094.0', 'X2102.0', 'X2110.0', 'X2118.0', 'X2126.0', 'X2134.0', 'X2142.0', 'X2150.0', 'X2158.0', 'X2166.0', 'X2174.0', 'X2182.0', 'X2190.0', 'X2198.0', 'X2206.0', 'X2214.0', 'X2222.0', 'X2230.0', 'X2238.0', 'X2246.0', 'X2254.0', 'X2262.0', 'X2270.0', 'X2278.0'];

    private const X_DATA = [
        'B1'=>  [0.0026827552, 0.0033706732, 0.0040859417, 0.0044719423, 0.0044294097, 0.0039644418, 0.0031221202, 0.0019804868, 0.0006682644, -0.00058406434, -0.0014776184, -0.0017443044, -0.0014020944, -0.00070123584, 0.000010443067, 0.00045170105, 0.00051960401, 0.00026494585, -0.000092461705, -0.00033590305, -0.00031605628, 0.000040844639, 0.00077704189, 0.0018686372, 0.0032255438, 0.0047805812, 0.0064012371, 0.0076224138, 0.0081461295, 0.0083251121, 0.008591176, 0.009532935, 0.011599077, 0.014790921, 0.018225662, 0.020602465, 0.021128733, 0.019468732, 0.016048545, 0.011760667, 0.0075263395, 0.0039688074, 0.001269338, -0.00067891594, -0.0021018577, -0.0031548834, -0.0038579367, -0.0041780518, -0.0041277655, -0.0038086639, -0.0033134304, -0.0027612832, -0.0023055845, -0.0020537395, -0.0020840962, -0.0024378079, -0.003056512, -0.0038185494, -0.0045566992, -0.005152781, -0.0054757018, -0.0054758689, -0.005184242, -0.0046144784, -0.0037765896, -0.0026528451, -0.00117594, 0.00069543463, 0.0026640745, 0.0042284084, 0.0050555421, 0.0051437742, 0.0046311608, 0.0038156868, 0.0031800512, 0.002931677, 0.0028986717, 0.0028207374, 0.0026673328, 0.0023723615, 0.0018421469, 0.00116889, 0.00050506886, 0.000052475891, -0.00012299592, -0.000031243078, 0.00017478091, 0.00026162539, 0.0003666456, 0.000883064, 0.0024115187, 0.005075179, 0.0094168065, 0.016004873, 0.024116211, 0.031774044, 0.036887985, 0.037945691, 0.033858325, 0.025357099, 0.014899381, 0.0051611224, -0.0023660867, -0.0071954038, -0.0096511347, -0.010407705, -0.010006314, -0.008756957, -0.0067030615, -0.0037754131, -0.000092939117, 0.0038415764, 0.0073909191, 0.0099679204, 0.011287821, 0.011292103, 0.0102374, 0.0085934866, 0.0067426786, 0.0048511708, 0.0030505902, 0.001411505, -0.000086697146, -0.001436852, -0.002549195, -0.003275797, -0.0037297651, -0.0037569171, -0.003465245, -0.0031984865, -0.0030440905, -0.0028700801, -0.0021417164, -0.00059418508, 0.0019175303, 0.0052108136, 0.0081034275, 0.0093798796, 0.0085450653, 0.0061051366, 0.0027393859, -0.0011617638, -0.0046210256, -0.007536137, -0.0094851349],
        'B2'=>  [0.0027815967, 0.0034748628, 0.0041914717, 0.0045568361, 0.0044654603, 0.0039620576, 0.0030999174, 0.0019564496, 0.00063067896, -0.00062631327, -0.0015057522, -0.0017701887, -0.0014064449, -0.00066856871, 0.000070841816, 0.0005037493, 0.00056048436, 0.00031157699, -0.000049753296, -0.00027971654, -0.00024383985, 0.00011850373, 0.00084666174, 0.0019136999, 0.003239261, 0.0047598751, 0.0063384962, 0.0075250119, 0.0080278311, 0.0081923036, 0.0084410356, 0.0093618622, 0.011382937, 0.014476998, 0.017800206, 0.020107787, 0.02060866, 0.018960124, 0.015622585, 0.01146929, 0.007349825, 0.0038663913, 0.0012305737, -0.00068573054, -0.0020989343, -0.003133239, -0.0038046853, -0.0040825442, -0.004009488, -0.0036837566, -0.0032148617, -0.0026921865, -0.0022499904, -0.0020076826, -0.0020418903, -0.0023780211, -0.0029835214, -0.0037597069, -0.0045175198, -0.0051193405, -0.0054399264, -0.0054414398, -0.0051408838, -0.0045683137, -0.0037558274, -0.0026732625, -0.0012324298, 0.00060522516, 0.0025526553, 0.0041110832, 0.0049322336, 0.0050184624, 0.0045067752, 0.0036873464, 0.0030545648, 0.0028186943, 0.0027997626, 0.0027604948, 0.0026624755, 0.0024247563, 0.0019045243, 0.0012091269, 0.00054185349, 0.000081656144, -0.000093421317, 0.000015682861, 0.00024226619, 0.00032081021, 0.0003973596, 0.00092807354, 0.0024639773, 0.005090307, 0.0093849674, 0.015880914, 0.023818647, 0.03126644, 0.036246318, 0.03729672, 0.033307146, 0.024959415, 0.014712432, 0.0051542921, -0.0022863557, -0.0071237637, -0.0095585966, -0.010259492, -0.0098628141, -0.0086289644, -0.0065689017, -0.0036777924, -0.00011408064, 0.0037081621, 0.0072016604, 0.0097462116, 0.011018083, 0.011047559, 0.010061627, 0.0084479274, 0.0066082892, 0.0048365965, 0.0031382868, 0.0015246304, 0.000047679423, -0.0013183953, -0.0024517286, -0.0032065224, -0.0036724445, -0.00385793, -0.0037882735, -0.0035059785, -0.0032082468, -0.0028195234, -0.0020216557, -0.00050669076, 0.0019790134, 0.0050287577, 0.0078105563, 0.0091456417, 0.0084757693, 0.006070795, 0.0025014079, -0.0014084865, -0.0048486837, -0.0077203056, -0.0096361758],
        'B3'=>  [0.0024999755, 0.0031876687, 0.0038955756, 0.0042487518, 0.0041695493, 0.0037116499, 0.002902776, 0.0018089678, 0.00056159397, -0.00063856982, -0.0014936873, -0.0017582534, -0.0014275849, -0.0007488642, -0.00007201008, 0.00034129465, 0.00038138567, 0.00012237582, -0.00023480954, -0.00047732648, -0.00045675089, -0.000099063938, 0.00062574854, 0.001694359, 0.0030266664, 0.0045621241, 0.0061627524, 0.0073632351, 0.0078565553, 0.0079815714, 0.0081494702, 0.008948856, 0.010850703, 0.013916498, 0.017308932, 0.019750722, 0.020421222, 0.018920045, 0.015651541, 0.011481954, 0.0073241331, 0.0038128681, 0.0011784802, -0.00070860446, -0.0020875144, -0.0031048246, -0.0037780879, -0.0040848437, -0.0040386943, -0.0037191638, -0.0032328267, -0.0026839862, -0.0022194467, -0.0019684371, -0.0020084744, -0.0023574927, -0.0029715868, -0.0037406539, -0.0044908533, -0.0050756661, -0.0053827725, -0.0053653992, -0.005051157, -0.0044644955, -0.003619516, -0.0024919419, -0.0010324557, 0.00076657376, 0.0026452474, 0.0041147787, 0.0048689833, 0.0049348203, 0.0044487882, 0.0036594828, 0.0030312296, 0.0027790936, 0.0027238075, 0.0026649165, 0.0025813507, 0.0023719182, 0.0018999719, 0.001257595, 0.00062317116, 0.00018297543, 0.000011520019, 0.000093998482, 0.00027114191, 0.00030579985, 0.00032820803, 0.00076801266, 0.0022017742, 0.0046943449, 0.0087919552, 0.015096603, 0.022948844, 0.030392399, 0.035398062, 0.036518708, 0.032611411, 0.02432717, 0.014109721, 0.0046254643, -0.0026626501, -0.0073293885, -0.0096266707, -0.010199789, -0.0096446481, -0.0082665887, -0.0060864049, -0.0030381309, 0.00068501261, 0.0046385331, 0.008197546, 0.01076318, 0.012024251, 0.011945154, 0.01080776, 0.0090272753, 0.0070055919, 0.0050442489, 0.0032295121, 0.0015756396, 0.000046020519, -0.0012741947, -0.002300954, -0.0030207855, -0.0033175016, -0.0032262288, -0.002905509, -0.0025487114, -0.0021999965, -0.001832189, -0.0011250353, 0.00056196889, 0.0031902529, 0.0063771131, 0.0090570701, 0.010202642, 0.0094190612, 0.0069977818, 0.0037399931, 0.00015178169, -0.0032015385, -0.0062030815, -0.0083380807],
        'M1'=>  [0.0041749543, 0.0052636666, 0.0061699017, 0.0065478538, 0.0063415496, 0.0056391712, 0.0045256275, 0.0030346923, 0.0012495504, -0.00060139236, -0.0020622327, -0.0027302485, -0.002542705, -0.0017696897, -0.0008415443, -0.00015023659, 0.00010428215, -0.00004402885, -0.00035975254, -0.00055523263, -0.00045890006, 0.000025845115, 0.00095071341, 0.0022886237, 0.0039186617, 0.0057295202, 0.0075573204, 0.0089190379, 0.0095161777, 0.0097263865, 0.010052575, 0.011157994, 0.013563547, 0.017257204, 0.021274749, 0.024191098, 0.024996389, 0.02317041, 0.019178256, 0.014098705, 0.00901898, 0.0047055241, 0.0014778537, -0.00080840691, -0.0024626083, -0.0036613499, -0.004410502, -0.0046934676, -0.0045593688, -0.0041101868, -0.0035049708, -0.0028714426, -0.0023512719, -0.0020929372, -0.0022018137, -0.0027002157, -0.0035148871, -0.0045104306, -0.0054926774, -0.0062687122, -0.0067101158, -0.0067755971, -0.0064826226, -0.0058624228, -0.0049349866, -0.0036829056, -0.0019980536, 0.00021648468, 0.0026795689, 0.0047563929, 0.0059110927, 0.0060441145, 0.005308284, 0.004116884, 0.0031961713, 0.0029042063, 0.0029891063, 0.0030779599, 0.0030062906, 0.0026091128, 0.0017579367, 0.00066595461, -0.00033031843, -0.0010011431, -0.0012536002, -0.0011125539, -0.00079873169, -0.00062506611, -0.0004661516, 0.00020380625, 0.0020613074, 0.0052167629, 0.010231774, 0.017599532, 0.026485479, 0.034803431, 0.040378105, 0.041638073, 0.037347876, 0.028169544, 0.016708041, 0.0058359304, -0.0027637936, -0.0085068382, -0.011473517, -0.012320387, -0.011760463, -0.010164433, -0.0075928825, -0.0040761977, 0.00012137216, 0.0045333942, 0.0084994035, 0.011418537, 0.012974677, 0.01315393, 0.012216471, 0.010504799, 0.0083604148, 0.0060801366, 0.0038369454, 0.0016816116, -0.00035602853, -0.0022039216, -0.0037976753, -0.0049853935, -0.0057126246, -0.0059202989, -0.0056666462, -0.0051459325, -0.004603392, -0.0039895899, -0.0028128151, -0.00070103747, 0.0025321017, 0.0065418743, 0.010366611, 0.012499565, 0.012029768, 0.0093727326, 0.0052710515, 0.00055489654, -0.0039378069, -0.0075319638, -0.0098317824],
        'M2'=>  [0.0043456457, 0.0054749209, 0.0063916082, 0.0067464686, 0.0065060854, 0.0057811253, 0.0046349051, 0.0031350092, 0.0013650168, -0.00044779122, -0.0018817576, -0.0025459286, -0.0023517238, -0.0015794584, -0.00066272187, 0.000014743999, 0.00025357262, 0.000092310118, -0.00024122337, -0.00046067277, -0.00036716531, 0.00012871715, 0.00106722, 0.002419844, 0.004054951, 0.0058503859, 0.0076368349, 0.0089439405, 0.0095033403, 0.0096945381, 0.010015699, 0.011124144, 0.013501774, 0.017107589, 0.020971579, 0.023714267, 0.024392914, 0.02252024, 0.018582186, 0.013633855, 0.0087230066, 0.0045626294, 0.001427697, -0.00079304865, -0.0024068465, -0.0035770689, -0.0043107662, -0.0045709754, -0.0044000233, -0.0039325305, -0.0033156218, -0.0026895644, -0.0021912737, -0.0019530979, -0.0020588764, -0.002530965, -0.0033178416, -0.0042795381, -0.005245077, -0.0060275239, -0.0064803213, -0.0065497826, -0.0062676407, -0.0056730993, -0.0047910474, -0.0036235128, -0.0020397843, 0.000071261151, 0.0024508713, 0.004464292, 0.0056072855, 0.0057524214, 0.0050650775, 0.0039555337, 0.0031438302, 0.0029634198, 0.0031466221, 0.0033149447, 0.0032778105, 0.0028761588, 0.0020082204, 0.00091351505, -0.00009116438, -0.00076463725, -0.001024257, -0.00089476589, -0.00060521398, -0.0004465571, -0.00029206503, 0.00037353529, 0.00219365, 0.0052760919, 0.010144351, 0.017293688, 0.025949627, 0.034026653, 0.039393723, 0.040540677, 0.036293324, 0.027283898, 0.016085332, 0.0055477861, -0.0027761068, -0.0083360896, -0.011230531, -0.01205628, -0.011496454, -0.0099143637, -0.0073874164, -0.003990938, 0.000038091119, 0.0042386926, 0.0080243563, 0.010832548, 0.01236075, 0.012604186, 0.011755438, 0.010131307, 0.0081099933, 0.0059692669, 0.0037648913, 0.0015835604, -0.00050147512, -0.0024205095, -0.0040198085, -0.005198664, -0.0058812615, -0.0060522323, -0.005830036, -0.0054786527, -0.0051043751, -0.0046157502, -0.003621571, -0.0017017958, 0.001455209, 0.0054378551, 0.0091773728, 0.011212457, 0.010695015, 0.0082239965, 0.0042870822, -0.00042910661, -0.0049872794, -0.00853677, -0.010693177],
        'M3'=>  [0.0046936357, 0.0059337909, 0.0069226492, 0.0072828811, 0.0070100473, 0.0062083192, 0.0049874266, 0.0033944736, 0.0014698871, -0.0005246264, -0.0021484487, -0.0029522062, -0.0028334786, -0.0020618141, -0.0010878451, -0.00034699289, -0.000046105983, -0.00015041891, -0.00043840037, -0.00061770499, -0.00048051661, 0.000071460476, 0.0010882221, 0.0025496767, 0.0043304386, 0.0062790606, 0.0081940647, 0.0096065309, 0.010235171, 0.010474245, 0.010880373, 0.012142347, 0.01475533, 0.018642781, 0.022770209, 0.025636438, 0.026210405, 0.024061417, 0.019752055, 0.014402333, 0.0091206795, 0.0046817823, 0.0013591105, -0.0010147057, -0.0027387138, -0.0039606723, -0.0046941885, -0.0049510188, -0.0047837482, -0.0043079327, -0.00368128, -0.0030307884, -0.0025116915, -0.0022591189, -0.0023614943, -0.0028513663, -0.0036589794, -0.0046579395, -0.0056400374, -0.0064371084, -0.0068998914, -0.0069698622, -0.0066654589, -0.0060216612, -0.0050728982, -0.0037788262, -0.002030534, 0.00025740787, 0.0028054798, 0.0049849236, 0.0062174243, 0.0063717063, 0.0056097456, 0.0043442808, 0.0033292053, 0.00297195, 0.0030496255, 0.0031327156, 0.0030673956, 0.0026575164, 0.0017615437, 0.00063915731, -0.00039403333, -0.0010861625, -0.0013604503, -0.0012359287, -0.00095474598, -0.00079786015, -0.00057848153, 0.00017854327, 0.002160707, 0.0055092289, 0.010769382, 0.018392161, 0.027491312, 0.035852592, 0.041256398, 0.042210352, 0.037546039, 0.02804454, 0.016420048, 0.0055687455, -0.0029630857, -0.0086292392, -0.011535812, -0.012396035, -0.01190313, -0.010351521, -0.0078402385, -0.0043840716, -0.00021411756, 0.0041816025, 0.0081335679, 0.011023809, 0.012543219, 0.01266676, 0.011664109, 0.009955233, 0.0078979935, 0.0057427445, 0.0036055946, 0.0015043584, -0.00050262158, -0.0023358604, -0.0038353878, -0.0049299132, -0.0056225946, -0.0058411225, -0.0056548994, -0.0052586552, -0.0048462274, -0.0042773234, -0.0032271557, -0.0011836709, 0.0021058191, 0.0061956942, 0.0099213095, 0.011860012, 0.011240382, 0.0085267257, 0.0044554844, -0.000053486721, -0.004377292, -0.0080665778, -0.010384159],
        'R1'=>  [0.0017831406, 0.0022868752, 0.0028629056, 0.0031693177, 0.0031157669, 0.0027320203, 0.0020795495, 0.0011971507, 0.00020293078, -0.00068091723, -0.0012045063, -0.0012111319, -0.00074967573, -0.000058581129, 0.00054199796, 0.00081948627, 0.00073556107, 0.00039188284, -0.000023020581, -0.00032081443, -0.00037958726, -0.00014233816, 0.00040393791, 0.0012241619, 0.0022612973, 0.0034830146, 0.0047865841, 0.0057615447, 0.0061296979, 0.0061760442, 0.0061775288, 0.0066197887, 0.007948433, 0.010280458, 0.01301736, 0.015149178, 0.016001273, 0.015125229, 0.012728871, 0.0094545614, 0.0060323342, 0.0030450118, 0.00075243285, -0.00088237837, -0.0020327293, -0.0028397518, -0.0033223676, -0.0034543546, -0.0032862504, -0.0029074778, -0.0024177416, -0.0019299259, -0.0015623254, -0.0014045658, -0.0015080655, -0.001871614, -0.0024304804, -0.0030896706, -0.0037247248, -0.0042154444, -0.0044740275, -0.0044877939, -0.0042812629, -0.0038735981, -0.0032742722, -0.0024652786, -0.0013684016, 0.00007066274, 0.0016683831, 0.002988958, 0.003712401, 0.0038243511, 0.0034634133, 0.0028963613, 0.0025106175, 0.0024767832, 0.002609072, 0.0026715063, 0.0025984598, 0.002331564, 0.0018434047, 0.0012420858, 0.00066299638, 0.00028202639, 0.0001667787, 0.00030638129, 0.00055291463, 0.00063951913, 0.00063650002, 0.00088834355, 0.0019056969, 0.0036567186, 0.0066215578, 0.011445292, 0.017724149, 0.023984386, 0.02862189, 0.030322039, 0.02779294, 0.021296397, 0.012782845, 0.0045466861, -0.0019958999, -0.0062404266, -0.0082904324, -0.0087337978, -0.0081269778, -0.0067408592, -0.0046426258, -0.0018252168, 0.0015604548, 0.0050920467, 0.0082069254, 0.010416013, 0.011464838, 0.011368899, 0.010397269, 0.0088849515, 0.0071061458, 0.0052944082, 0.0035433401, 0.0018561833, 0.00026166058, -0.0011383706, -0.0022245334, -0.0029498453, -0.0032586644, -0.0030499236, -0.0024669815, -0.001803625, -0.0012959638, -0.00085106888, -0.00010365, 0.0012697512, 0.0035802419, 0.0065874238, 0.009507996, 0.01107505, 0.010575563, 0.008520212, 0.0052868072, 0.0014791156, -0.0020848783, -0.005033372, -0.0069713001],
        'R2'=>  [0.0025835366, 0.0033173123, 0.004048497, 0.0043936195, 0.0042963708, 0.0037932943, 0.0029239075, 0.0017643358, 0.00046742673, -0.00071377319, -0.0014855413, -0.0016448944, -0.0012370463, -0.0005301073, 0.00013258299, 0.00049521687, 0.00049872557, 0.00022539168, -0.00015072375, -0.00041600273, -0.00041875997, -0.000092096438, 0.00060445466, 0.0016434435, 0.0029337143, 0.0043971343, 0.0058993995, 0.0070096711, 0.0074311793, 0.0074872444, 0.0075761019, 0.0082522202, 0.0099638514, 0.01277354, 0.015943473, 0.01829361, 0.019051181, 0.017808542, 0.014877067, 0.011032173, 0.0071041691, 0.0037217769, 0.0011340178, -0.00073248509, -0.0020717829, -0.0030252093, -0.0036073492, -0.0038112025, -0.0036716296, -0.003284829, -0.0027751082, -0.0022573147, -0.0018460694, -0.001647124, -0.0017367044, -0.0021173265, -0.0027299786, -0.0034812852, -0.0042131934, -0.0047844169, -0.005093711, -0.005108471, -0.0048516998, -0.004356531, -0.0036559519, -0.0027107452, -0.0014301895, 0.00023864434, 0.0020529295, 0.0035049662, 0.004269165, 0.0043506841, 0.0039238944, 0.0032866478, 0.0028671646, 0.0028180312, 0.0028875761, 0.0028649401, 0.0027363251, 0.0024438766, 0.0019070276, 0.0012404843, 0.00060055498, 0.00012895079, -0.000072124938, 0.000024710795, 0.00025274113, 0.00034189798, 0.00038280166, 0.00078781741, 0.0021037932, 0.0043441425, 0.008003219, 0.013663589, 0.020799106, 0.02771063, 0.03260041, 0.034099031, 0.030956948, 0.023594256, 0.014149813, 0.005138285, -0.0019532735, -0.0065695397, -0.0088624377, -0.0094406381, -0.0089075137, -0.0076086177, -0.0055435775, -0.002643222, 0.00090604363, 0.0046526156, 0.0080278749, 0.010468058, 0.011641528, 0.011568846, 0.010552835, 0.0089537445, 0.0071134884, 0.0052569509, 0.0034762183, 0.0017803608, 0.00020162427, -0.0011801083, -0.0022831222, -0.0030506533, -0.0033893897, -0.003266867, -0.0028317191, -0.0022915094, -0.0017844825, -0.0013153993, -0.00062710926, 0.00086503563, 0.0033002181, 0.0062601268, 0.0091246357, 0.010692426, 0.01011705, 0.0077868993, 0.0044492749, 0.00064612826, -0.0029620922, -0.0058196201, -0.0076178857],
        'R3'=>  [0.0016115956, 0.0021120175, 0.0027263984, 0.0031010301, 0.0031179418, 0.0027890687, 0.0021400512, 0.0012455111, 0.00023860931, -0.00067287637, -0.0012259822, -0.0012604803, -0.00081934093, -0.0001534663, 0.00043298939, 0.00070893706, 0.00063099043, 0.00029701521, -0.00010651941, -0.00040027985, -0.00046417443, -0.0002348655, 0.00030345016, 0.00114107, 0.0022099384, 0.0034731859, 0.0048251869, 0.0058413423, 0.0062340996, 0.0062740543, 0.0062709395, 0.0067177494, 0.0080739986, 0.010505301, 0.01341023, 0.015737111, 0.016742045, 0.015912937, 0.013440011, 0.0099921776, 0.0063620894, 0.0031822992, 0.00075622404, -0.0009502836, -0.0021459772, -0.0029782071, -0.0034637356, -0.0035959503, -0.0034264284, -0.0030372308, -0.0025258325, -0.0020130479, -0.0016267246, -0.001449883, -0.0015443069, -0.0019227123, -0.0025162208, -0.0032148703, -0.0038848436, -0.0044084061, -0.0046819169, -0.0046895714, -0.0044582859, -0.0040151854, -0.0033784581, -0.0025414058, -0.0013872562, 0.00013437703, 0.0017920083, 0.0031450805, 0.0038880911, 0.0040004067, 0.0036151323, 0.0030256442, 0.0026275336, 0.0025791894, 0.002673805, 0.0027038348, 0.0026224449, 0.0023780228, 0.0018927362, 0.0012650047, 0.00066182757, 0.00023836586, 0.000087807726, 0.00020996532, 0.00044086043, 0.00051033974, 0.00049479038, 0.00076014764, 0.0017886753, 0.003582011, 0.0066155638, 0.011503669, 0.017863829, 0.024248619, 0.029009715, 0.030766612, 0.028215557, 0.021622973, 0.012952124, 0.0045745564, -0.0020310732, -0.0062541086, -0.0082553737, -0.0086414497, -0.007982811, -0.0065710098, -0.0044056987, -0.0014619628, 0.002088398, 0.0057687331, 0.0089786714, 0.011225047, 0.012238748, 0.012063318, 0.010963775, 0.0093075335, 0.0074183913, 0.0054481397, 0.0035500349, 0.0017474638, 0.0001051717, -0.0012935897, -0.0023411908, -0.0029526136, -0.00315139, -0.0029162155, -0.0024165178, -0.0019137027, -0.0014198803, -0.00086902693, -0.000092882918, 0.001379668, 0.0038134758, 0.0068742004, 0.0096737407, 0.011188569, 0.010789509, 0.0086985203, 0.005441437, 0.0016910606, -0.0019179704, -0.0050103753, -0.0070741652],
        'T1'=>  [0.0036038118, 0.0045595248, 0.0054226574, 0.0057981717, 0.0056304093, 0.005003491, 0.0039458624, 0.0025418585, 0.00093390362, -0.00057721464, -0.001663107, -0.0020372565, -0.0016806111, -0.00091259775, -0.00011956432, 0.00037871828, 0.00049188937, 0.00026107093, -0.000087020198, -0.00029830696, -0.00022769354, 0.00021824343, 0.0010856247, 0.0023385601, 0.0038507266, 0.005524572, 0.0072107082, 0.0084402151, 0.0089407088, 0.0091125714, 0.0094517022, 0.010602373, 0.012999387, 0.01657657, 0.020383382, 0.023036102, 0.023639573, 0.021807153, 0.0180414, 0.013326918, 0.0086205145, 0.0046042441, 0.00154061, -0.00069386914, -0.0023364911, -0.003521238, -0.0042514298, -0.0045230435, -0.0044044796, -0.0040023471, -0.0034346539, -0.0028322542, -0.0023433347, -0.0021027795, -0.0021822001, -0.0026048699, -0.0033243124, -0.004205443, -0.0050630835, -0.0057507008, -0.0061492347, -0.0062092692, -0.0059393011, -0.0053778528, -0.0045579006, -0.003449457, -0.0019215036, 0.00010932676, 0.0023231588, 0.0041251839, 0.0050888252, 0.0051846234, 0.0046187988, 0.0038149371, 0.0033191564, 0.0032927243, 0.003443314, 0.0034582429, 0.0032856278, 0.0028469365, 0.0020899198, 0.0011602177, 0.00025318394, -0.00040286416, -0.00069999223, -0.00059672771, -0.0003125892, -0.00015554746, 0.000034186909, 0.00072063023, 0.0025563061, 0.005652165, 0.010570474, 0.017856365, 0.026656706, 0.034900352, 0.04041953, 0.041645806, 0.037351165, 0.028212618, 0.016857836, 0.0061125201, -0.00236317, -0.0079959109, -0.010940331, -0.011867999, -0.011466437, -0.010091079, -0.0077957972, -0.0045306217, -0.00052530353, 0.003720263, 0.0075709657, 0.010400051, 0.011851916, 0.011933022, 0.010953247, 0.0093097007, 0.0073679197, 0.0053526484, 0.0033262151, 0.0013602825, -0.00048949022, -0.0021726051, -0.0035781583, -0.0045518395, -0.0050595785, -0.0052592265, -0.0051668724, -0.0048225108, -0.0045620557, -0.0042757723, -0.0033743968, -0.0015015763, 0.0014890538, 0.0051698387, 0.0085683232, 0.010184753, 0.0093365433, 0.0067111244, 0.0029424559, -0.0012026652, -0.0048983926, -0.0078769987, -0.0097719701],
        'T2'=>  [0.0040131491, 0.0050470363, 0.0059450157, 0.00633932, 0.0061485036, 0.005454069, 0.0043158852, 0.0027904608, 0.0010406504, -0.00064395228, -0.0018696042, -0.002346576, -0.0020529774, -0.0012872466, -0.00046036573, 0.00010552184, 0.00026465586, 0.000079347403, -0.0002299113, -0.00041145855, -0.00029975997, 0.00019644955, 0.0011345551, 0.0024899843, 0.0041366867, 0.0059555974, 0.0077685695, 0.0090942848, 0.0096547622, 0.0098608872, 0.010270333, 0.011578707, 0.014256031, 0.018211463, 0.022407562, 0.025335336, 0.025996136, 0.023984406, 0.019835338, 0.01463917, 0.0094630634, 0.0050641694, 0.0017133587, -0.00072256237, -0.0024782219, -0.0037292815, -0.0045078103, -0.0048198826, -0.0047251992, -0.0043271445, -0.0037635027, -0.0031418167, -0.0026140814, -0.0023383435, -0.0024041492, -0.0028593051, -0.0036371278, -0.004600429, -0.0055550532, -0.0063057728, -0.0067093759, -0.0067251842, -0.0064034145, -0.0057742381, -0.0048594191, -0.003629304, -0.00192084, 0.00034129739, 0.002791275, 0.0047365744, 0.0057311091, 0.0058036535, 0.0051651215, 0.0042426945, 0.003629762, 0.0035202778, 0.0035901351, 0.0035175749, 0.0033048636, 0.0028400044, 0.0020392421, 0.0010506276, 0.000075025142, -0.00063096581, -0.0009555844, -0.00089534168, -0.00065665966, -0.0004851702, -0.00024031963, 0.00054427661, 0.0025734424, 0.0060357456, 0.01146582, 0.019377265, 0.028892851, 0.037715726, 0.043508209, 0.044597328, 0.039799739, 0.029918145, 0.017772269, 0.0064139143, -0.0025220129, -0.0084227063, -0.011449207, -0.012417693, -0.012070704, -0.010713344, -0.0083547058, -0.0049890559, -0.00080593699, 0.0037153468, 0.0078001642, 0.010768347, 0.012272041, 0.012305554, 0.01123462, 0.0094908644, 0.0074381568, 0.0053473185, 0.0033115046, 0.0013320737, -0.00058996433, -0.0023228023, -0.0037052981, -0.0046853498, -0.0052281106, -0.0053882874, -0.0052751866, -0.0050653196, -0.0048852852, -0.0044619665, -0.0034718004, -0.0014616144, 0.0016226174, 0.005243225, 0.0084443465, 0.010052911, 0.0093834745, 0.0068379124, 0.0032939999, -0.00086496002, -0.0050680595, -0.0088506695, -0.011276547],
        'T3'=>  [0.0024608725, 0.0032070805, 0.0039565992, 0.0043312805, 0.0042647729, 0.0037951006, 0.0029730827, 0.0018478737, 0.0005640944, -0.00065170869, -0.0015061841, -0.0017560681, -0.0014065336, -0.00072072126, -0.000052715233, 0.0003328374, 0.00036279354, 0.00009285313, -0.00028544106, -0.00055360957, -0.00056583993, -0.00024016679, 0.00044108293, 0.0014590049, 0.0027439503, 0.004218033, 0.005746555, 0.0068908515, 0.0073434822, 0.0074030906, 0.0074356282, 0.0080130324, 0.0096324654, 0.012428505, 0.015693048, 0.018207509, 0.01914007, 0.017999765, 0.015056497, 0.011100721, 0.0070358068, 0.0035482794, 0.00091207231, -0.00094751228, -0.0022547306, -0.0031689897, -0.0037243378, -0.0039079688, -0.0037618107, -0.003369197, -0.0028397045, -0.0022920612, -0.0018591634, -0.0016491566, -0.0017371469, -0.0021342081, -0.0027795869, -0.0035623391, -0.004314696, -0.0049025812, -0.0052181059, -0.0052326848, -0.0049789101, -0.0045005786, -0.0038039335, -0.0028485493, -0.0015248717, 0.00022237684, 0.0021516012, 0.003737289, 0.0045893644, 0.0046894634, 0.0042049275, 0.0034504901, 0.0029111479, 0.0027735038, 0.0028114831, 0.0027770386, 0.0026354378, 0.0023254354, 0.0017572372, 0.0010591353, 0.00039396135, -0.000086018365, -0.00029020471, -0.00019003591, 0.000042252435, 0.00011734151, 0.00014248722, 0.00052296714, 0.0017736382, 0.0039135665, 0.007459179, 0.013023688, 0.020104017, 0.027028836, 0.031978142, 0.033549957, 0.030491242, 0.023189705, 0.013803942, 0.0048793075, -0.0021077292, -0.0066367299, -0.0088506266, -0.0093234982, -0.0086864037, -0.007239446, -0.004992852, -0.0018874645, 0.0018648767, 0.0057611517, 0.0091769807, 0.011551994, 0.01260715, 0.012379136, 0.01119908, 0.0094553968, 0.0074787536, 0.005455608, 0.0034933626, 0.0016260117, -0.000063936975, -0.0014580673, -0.002517411, -0.0031952511, -0.0034573816, -0.00335164, -0.0029744022, -0.002474433, -0.0018888185, -0.0013525614, -0.00055718527, 0.0010375765, 0.0035850317, 0.0067255981, 0.0098312655, 0.011724016, 0.011420466, 0.0091910036, 0.0056146556, 0.0013756825, -0.0025251266, -0.0056727882, -0.0077651786],
        'W1'=>  [0.0017174324, 0.0021695786, 0.0027601409, 0.00311499, 0.0031367794, 0.0028210548, 0.0021747986, 0.0012639494, 0.00023006317, -0.00066665758, -0.0012001548, -0.0011917091, -0.00069807534, 0.000013216704, 0.00063011417, 0.00092807645, 0.00087245519, 0.00053594756, 0.00010866502, -0.00020574895, -0.00028950543, -0.000084776249, 0.00043385205, 0.0012467823, 0.0022920063, 0.0035345485, 0.0048863403, 0.0059144739, 0.0063253483, 0.0064047305, 0.0064474628, 0.0069217752, 0.0082663205, 0.010641253, 0.013428865, 0.015581683, 0.016404292, 0.015465306, 0.012985417, 0.0096154669, 0.006130904, 0.0031441157, 0.00092203001, -0.00063349801, -0.0017390918, -0.0025372331, -0.0030707698, -0.0033182946, -0.0032915396, -0.0030367542, -0.0026406685, -0.0021998445, -0.0018256598, -0.0016306568, -0.001689303, -0.0020066898, -0.0025343813, -0.0031872438, -0.0038181134, -0.0042991093, -0.0045582466, -0.0045623612, -0.0043275184, -0.0038847844, -0.0032241703, -0.0023009416, -0.001031211, 0.00059315341, 0.0023308534, 0.0036953352, 0.0043691248, 0.0043998393, 0.0039560529, 0.0033028563, 0.0028258131, 0.0026712643, 0.002621338, 0.0024995243, 0.0023415133, 0.0021022237, 0.0016939307, 0.0011838443, 0.00070674793, 0.00036528462, 0.00024245438, 0.0003765063, 0.00059760013, 0.00063953572, 0.00061637297, 0.00090651831, 0.0019702751, 0.0037845613, 0.006868368, 0.011827482, 0.018199688, 0.024511708, 0.029138703, 0.030744191, 0.028088551, 0.021528494, 0.013036551, 0.0049135704, -0.0014123899, -0.0054088919, -0.0073271762, -0.0077799372, -0.007321449, -0.0062156208, -0.0044206325, -0.0017846546, 0.0015758825, 0.0051739314, 0.0083506061, 0.010495128, 0.011337903, 0.01093846, 0.0096907318, 0.0080078328, 0.0062092706, 0.0045172297, 0.0029665807, 0.001529417, 0.0002449571, -0.00078109966, -0.0015052578, -0.0019057957, -0.0020340404, -0.001962519, -0.0017957176, -0.0015727921, -0.0015108032, -0.0014862834, -0.0010670754, 0.00010657421, 0.0023057291, 0.0052193063, 0.0082411263, 0.0098944772, 0.0094323717, 0.0072495644, 0.0039238753, 0.000093409282, -0.0034986541, -0.0065128645, -0.0084280865],
        'W2'=>  [0.0029101009, 0.0037657539, 0.0045904289, 0.0050070523, 0.0049336189, 0.0044048536, 0.003457709, 0.0021718722, 0.00067490555, -0.0007634192, -0.0017986293, -0.0021573782, -0.0018317646, -0.0011063394, -0.00036125604, 0.00011087023, 0.00020824371, -0.000013829893, -0.00036024812, -0.00058898143, -0.00054671406, -0.00016137985, 0.00061774469, 0.0017719123, 0.0031991987, 0.0048215515, 0.00648775, 0.0077254097, 0.0082357451, 0.0083676763, 0.0085398806, 0.0093583064, 0.011321913, 0.014492252, 0.018035566, 0.020648178, 0.021467239, 0.02000146, 0.01662034, 0.01222041, 0.0077635599, 0.0039577107, 0.0010824918, -0.00094652752, -0.002399914, -0.0034367219, -0.0040801116, -0.0043293801, -0.0042334958, -0.0038648127, -0.0033384163, -0.0027799699, -0.0023259718, -0.0021005259, -0.0021885785, -0.002601, -0.0032583734, -0.0040635346, -0.0048432508, -0.0054495125, -0.0057807681, -0.0058195139, -0.0055800029, -0.0050607445, -0.0042894464, -0.0032185295, -0.001708812, 0.0002765448, 0.0024181451, 0.0041271378, 0.0050249719, 0.0051106024, 0.0045629493, 0.0037427936, 0.0031347766, 0.0029425267, 0.00292444, 0.0028142889, 0.0026011982, 0.0022379223, 0.0016339105, 0.00086858257, 0.00012077846, -0.00040886895, -0.00065724947, -0.00059951015, -0.0003844582, -0.00027259198, -0.00014798528, 0.00040257754, 0.0019591195, 0.0045516794, 0.0087271119, 0.015105912, 0.023044346, 0.030682869, 0.036016129, 0.037517939, 0.033926897, 0.02574674, 0.015383147, 0.0055687348, -0.002113462, -0.0070893876, -0.0095750913, -0.010271179, -0.0098263891, -0.008552663, -0.0063880966, -0.0032496057, 0.00069331151, 0.0049284617, 0.0086857239, 0.011304282, 0.012453611, 0.012199697, 0.01088829, 0.0090084663, 0.0069457246, 0.004938757, 0.0030570168, 0.0013255604, -0.00022492358, -0.001552649, -0.0025022617, -0.0030554833, -0.0032689073, -0.0031584387, -0.0028430035, -0.0025303622, -0.0023055633, -0.0020279142, -0.0013175865, 0.00021367603, 0.0029601455, 0.0066205659, 0.010091604, 0.012043796, 0.011804862, 0.0096263457, 0.0058114948, 0.0012477085, -0.0028569996, -0.0061310763, -0.0083958879],
        'W3'=>  [0.0040643211, 0.005122791, 0.0060258321, 0.0064219208, 0.0062470045, 0.0055639576, 0.0044428743, 0.0029457978, 0.0011870126, -0.00054615579, -0.0018387304, -0.0023550971, -0.0020846119, -0.0013176693, -0.00045269303, 0.00012994983, 0.00030227803, 0.0001237323, -0.00019248632, -0.00039653908, -0.00030842054, 0.00019615251, 0.0011360438, 0.0024823956, 0.0041228975, 0.0059489375, 0.0077819098, 0.0091408668, 0.0097324625, 0.0099628735, 0.010361183, 0.011618882, 0.014236707, 0.01816809, 0.02237102, 0.025311666, 0.026018992, 0.024055392, 0.019924531, 0.014709161, 0.0095166024, 0.0051041991, 0.0017372726, -0.00071860326, -0.0025036107, -0.0037815413, -0.0045868261, -0.0049160016, -0.0048162849, -0.0043879212, -0.003789945, -0.0031508247, -0.0026141829, -0.0023320715, -0.0024110791, -0.0028790436, -0.0036760638, -0.0046617547, -0.0056326697, -0.0063854083, -0.006801228, -0.0068461429, -0.0065381597, -0.0059099691, -0.0049827411, -0.0037219613, -0.0019627099, 0.00035005785, 0.0028802948, 0.0049356511, 0.0060251886, 0.006123947, 0.0054308162, 0.0044006826, 0.0036504429, 0.003440279, 0.003469131, 0.0034096551, 0.003198083, 0.0027224582, 0.0019090092, 0.00092378911, -0.000019539568, -0.00069566059, -0.0009956822, -0.0009135438, -0.00065516616, -0.00051246467, -0.0003235222, 0.00042849369, 0.0024601235, 0.0058782394, 0.011293461, 0.019302385, 0.029028658, 0.038112231, 0.044131216, 0.045384035, 0.040582359, 0.030490436, 0.017981961, 0.0062869405, -0.0028559202, -0.008876536, -0.012008048, -0.012993312, -0.01255229, -0.011106626, -0.0086316317, -0.0050839782, -0.00066223746, 0.0040698797, 0.008286736, 0.011349065, 0.012924387, 0.012980396, 0.011846174, 0.010011178, 0.0078960089, 0.005659386, 0.0034028552, 0.0012051362, -0.00083703286, -0.0026844235, -0.0041813622, -0.005205899, -0.0058614332, -0.0060766027, -0.005957583, -0.0056991116, -0.0054218802, -0.0051503787, -0.004248308, -0.0023199115, 0.00088048755, 0.0050425958, 0.0089226188, 0.011093968, 0.010581847, 0.0079411278, 0.0037464376, -0.0013944216, -0.0062475968, -0.010319945, -0.012831115],
    ];

    private const Y_LABELS = ['Heating value', 'C', 'H', 'N', 'Starch', 'Ash'];

    private const Y_DATA = [
        'B1'=>  [18373, 41.6150017, 6.5650001, 1.8099999, 59.9199982, 2.3900001],
        'B2'=>  [18536, 41.4049988, 6.5450001, 1.91, 60.4399986, 2.1900001],
        'B3'=>  [18418, 41.7900009, 6.5050001, 1.71, 60.9199982, 2.4400001],
        'M1'=>  [18551, 41.9249992, 6.5799999, 1.015, 74.8199997, 1.36],
        'M2'=>  [18561, 41.6650009, 6.6950002, 0.915, 76.5400009, 1.23],
        'M3'=>  [18594, 42.1466675, 6.7533336, 1.1766666, 72.2200012, 1.1799999],
        'R1'=>  [18151, 40.6450005, 6.6700001, 1.34, 61.9500008, 1.5700001],
        'R2'=>  [18244, 41.3050003, 6.8049998, 1.755, 60.6199989, 1.5700001],
        'R3'=>  [18230, 41.1349983, 6.8850002, 1.63, 65.6299973, 1.62],
        'T1'=>  [18143, 40.3650017, 6.835, 1.53, 70.9599991, 1.58],
        'T2'=>  [18317, 41.0099983, 6.915, 1.8049999, 68.8499985, 1.85],
        'T3'=>  [18255, 41.25, 6.9050002, 1.465, 70.8399963, 1.45],
        'W1'=>  [18594, 41.0800018, 6.8000002, 2.145, 62.6500015, 1.84],
        'W2'=>  [18462, 41.4550018, 6.77, 1.84, 68.4199982, 1.52],
        'W3'=>  [18406, 40.9300003, 6.6399999, 1.62, 69.9199982, 1.6],
    ];

    private const YSC_LABELS = ['Heating value', 'C', 'H', 'N', 'Starch', 'Ash'];

    private const YSC_DATA = [
        'B1' => [-0.1005049,  0.6265746, -1.1716630,  0.6767926, -1.2580072,  1.8128533],
        'B2' => [ 0.9233889,  0.1882929, -1.3185289,  0.9682348, -1.1653494,  1.2929146],
        'B3' => [ 0.1821652,  0.9918026, -1.6122606,  0.3853510, -1.0798193,  1.9428380],
        'M1' => [ 1.0176123,  1.2735477, -1.0615151, -1.6401702,  1.3969938, -0.8648315],
        'M2' => [ 1.0804278,  0.7309243, -0.2170342, -1.9316121,  1.7034774, -1.2027917],
        'M3' => [ 1.2877192,  1.7361753,  0.2113251, -1.1690060,  0.9337054, -1.3327767],
        'R1' => [-1.4950106, -1.3978438, -0.4006172, -0.6929840, -0.8962852, -0.3188956],
        'R2' => [-0.9108258, -0.0204066,  0.5907251,  0.5164999, -1.1332755, -0.3188956],
        'R3' => [-0.9987676, -0.3752053,  1.1781915,  0.1521975, -0.2405541, -0.1889112],
        'T1' => [-1.5452631, -1.9822088,  0.8110254, -0.1392444,  0.7091881, -0.2928989],
        'T2' => [-0.4522721, -0.6360836,  1.3984889,  0.6622205,  0.3332114,  0.4090184],
        'T3' => [-0.8417287, -0.1351937,  1.3250574, -0.3286816,  0.6878051, -0.6308591],
        'W1' => [ 1.2877192, -0.4899845,  0.5540116,  1.6531233, -0.7715535,  0.3830215],
        'W2' => [ 0.4585537,  0.2926505,  0.3337114,  0.7642255,  0.2565905, -0.4488805],
        'W3' => [ 0.1067865, -0.8030416, -0.6209175,  0.1230533,  0.5238725, -0.2409050],
    ];

    private const SCALED_CENTER = [
        'Heating value' => 18389.000000,
        'C'             => 41.314778,
        'H'             => 6.724556,
        'N'             => 1.577778,
        'Starch'        => 66.979999,
        'Ash'           => 1.692667,
    ];

    private const SCALED_SCALE = [
        'Heating value' => 159.1961952,
        'C'             => 0.4791506,
        'H'             => 0.1361787,
        'N'             => 0.3431216,
        'Starch'        => 5.6120510,
        'Ash'           => 0.3846607,
    ];

    /**
     * Cereal names
     *
     * @return string[]
     */
    public function getCereals(): array
    {
        return self::CEREALS;
    }

    /**
     * Raw data without labels
     * [[0.002682755, 0.003370673, 0.004085942, ... ], [0.002781597, 0.003474863, 0.004191472, ... ], ... ]
     *
     * @return float[][]
     */
    public function getXData(): array
    {
        return \array_values(self::X_DATA);
    }

    /**
     * Raw data with each observation labeled
     * ['B1' => ['X1126.0' => 0.002682755, 'X1134.0' => 0.003370673, 'X1142.0' => 0.004085942, ... ]]
     *
     * @return array<string, array<string, float>>
     */
    public function getLabeledXData(): array
    {
        /** @var array<string, array<string, float>> */
        return \array_map(
            function (array $data) {
                return \array_combine(self::X_LABELS, $data);
            },
            self::X_DATA
        );
    }

    /**
     * Raw data without labels
     * [[18373, 41.61500, 6.565000, ... ], [18536, 41.40500, 6.545000, ... ], ... ]
     *
     * @return float[][]
     */
    public function getYData(): array
    {
        return \array_values(self::Y_DATA);
    }

    /**
     * Raw data with each observation labeled
     * ['B1' => ['Heating value' => 18373, 'C' => 41.61500, 'H' => 6.565000, ... ]]
     *
     * @return array<string, array<string, float>>
     */
    public function getLabeledYData(): array
    {
        /** @var array<string, array<string, float>> */
        return \array_map(
            function (array $data) {
                return \array_combine(self::Y_LABELS, $data);
            },
            self::Y_DATA
        );
    }

    /**
     * Raw data without labels
     * [[-0.1005049, 0.6265746, -1.1716630, ... ], [0.9233889, 0.1882929, -1.3185289, ... ], ... ]
     *
     * @return float[][]
     */
    public function getYscData(): array
    {
        return \array_values(self::YSC_DATA);
    }

    /**
     * Raw data with each observation labeled
     * ['B1' => ['Heating value' => -0.1005049, 'C' => 0.6265746, 'H' => -1.1716630, ... ]]
     *
     * @return array<string, array<string, float>>
     */
    public function getLabeledYscData(): array
    {
        /** @var array<string, array<string, float>> */
        return \array_map(
            function (array $data) {
                return \array_combine(self::YSC_LABELS, $data);
            },
            self::YSC_DATA
        );
    }

    /**
     * @return array<string, float>
     */
    public function getScaledCenter(): array
    {
        return self::SCALED_CENTER;
    }

    /**
     * @return array<string, float>
     */
    public function getScaledScale(): array
    {
        return self::SCALED_SCALE;
    }
}
