<div align="center">

# TicketSquad

[![GitHub license](https://img.shields.io/github/license/marcuwynu23/TicketSquad)](https://github.com/marcuwynu23/TicketSquad/blob/main/LICENSE)
[![GitHub stars](https://img.shields.io/github/stars/marcuwynu23/TicketSquad)](https://github.com/marcuwynu23/TicketSquad/stargazers)
[![GitHub issues](https://img.shields.io/github/issues/marcuwynu23/TicketSquad)](https://github.com/marcuwynu23/TicketSquad/issues)

</div>

TicketSquad is a web-based ticketing management system that helps organizations manage their ticketing processes efficiently.

## Features

- Create, view, edit, and delete tickets
- Prioritize tickets based on status and priority
- Track ticket progress and resolution
- Responsive design for usability on various devices

## Technologies Used

- ASP.NET Core MVC
- Entity Framework Core
- PostgreSQL
- HTML/CSS
- JavaScript
- Bootstrap (with MDBootstrap5)
- Font Awesome

## Getting Started

To get started with the TicketSquad project, follow these steps:

1. Clone this repository to your local machine.
2. Open the project in your preferred IDE.
3. Restore NuGet packages and build the solution.
4. Configure MongoDB connection string in `appsettings.json`.
5. Run the project and navigate to the application in your web browser.

## Usage

- Create tickets: Click on "Create New Ticket" and fill in the details.
- View tickets: Tickets are listed on the main page. Click on a ticket to view its details.
- Edit tickets: Click on "Edit" next to a ticket to modify its details.
- Delete tickets: Click on "Delete" next to a ticket to remove it from the list.

## Contribution

Contributions to the TicketSquad project are welcome! Here are some ways you can contribute:

- Submit bug reports or feature requests by opening an issue.
- Fork the repository and make your changes. Then, submit a pull request for review.
- Improve the documentation by fixing typos or adding more details where needed.
- Spread the word about TicketSquad by sharing it with others or starring the repository.

Please make sure to follow the project's code of conduct and contribution guidelines when submitting contributions.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.
