﻿namespace ChatGptNet.Models;

/// <summary>
/// A tool call generated by the model, such as a function call.
/// </summary>
public class ChatGptToolCall
{
    /// <summary>
    /// The ID of the tool call.
    /// </summary>
    public string Id { get; set; } = string.Empty;

    /// <summary>
    /// The type of the tool.
    /// </summary>
    public string Type { get; set; } = string.Empty;

    /// <summary>
    /// The function that the model called.
    /// </summary>
    public ChatGptFunctionCall? Function { get; set; }
}