# IChatGptClient.SetupAsync method (1 of 2)

Setups a new conversation with a system message, that is used to influence assistant behavior.

```csharp
public Task<Guid> SetupAsync(string message, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| message | The system message. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The unique identifier of the new conversation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *message* is `null`. |

## Remarks

This method creates a new conversation with a system message and a random Conversation Id. Then, call [`AskAsync`](./AskAsync.md) with this Id to start the actual conversation.

## See Also

* method [AskAsync](./AskAsync.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.SetupAsync method (2 of 2)

Setups a conversation with a system message, that is used to influence assistant behavior.

```csharp
public Task<Guid> SetupAsync(Guid conversationId, string message, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation, used to automatically retrieve previous messages in the chat history. |
| message | The system message. |
| cancellationToken | The token to monitor for cancellation requests. |

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *message* is `null`. |

## Remarks

This method creates a new conversation, with a system message and the given *conversationId*. If a conversation with this Id already exists, it will be automatically cleared. Then, call [`AskAsync`](./AskAsync.md) to start the actual conversation.

## See Also

* method [AskAsync](./AskAsync.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
