# IChatGptClient.LoadConversationAsync method (1 of 2)

Loads messages into a new conversation.

```csharp
public Task<Guid> LoadConversationAsync(IEnumerable<ChatGptMessage> messages, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| messages | Messages to load into a new conversation. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The unique identifier of the new conversation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *messages* is `null`. |

## Remarks

This method creates a new conversation with a random Conversation Id. Then, call [`AskAsync`](./AskAsync.md) or [`AskStreamAsync`](./AskStreamAsync.md) with this Id to start the actual conversation.

The total number of messages never exceeds the message limit defined in [`MessageLimit`](../ChatGptOptions/MessageLimit.md). If *messages* contains more, only the latest ones are loaded.

## See Also

* property [MessageLimit](../ChatGptOptions/MessageLimit.md)
* method [AskAsync](./AskAsync.md)
* method [AskStreamAsync](./AskStreamAsync.md)
* class [ChatGptMessage](../../ChatGptNet.Models/ChatGptMessage.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.LoadConversationAsync method (2 of 2)

Loads messages into conversation history.

```csharp
public Task<Guid> LoadConversationAsync(Guid conversationId, IEnumerable<ChatGptMessage> messages, 
    bool replaceHistory = true, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| messages | The messages to load into conversation history. |
| replaceHistory | `true` to replace all the existing messages; `false` to mantain them. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The unique identifier of the conversation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *messages* is `null`. |

## Remarks

The total number of messages never exceeds the message limit defined in [`MessageLimit`](../ChatGptOptions/MessageLimit.md). If *messages* contains more, only the latest ones are loaded.

## See Also

* property [MessageLimit](../ChatGptOptions/MessageLimit.md)
* class [ChatGptMessage](../../ChatGptNet.Models/ChatGptMessage.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
