# IChatGptClient.GenerateEmbeddingAsync method (1 of 2)

Generates embeddings for a list of texts.

```csharp
public Task<EmbeddingResponse> GenerateEmbeddingAsync(IEnumerable<string> texts, 
    EmbeddingParameters? parameters = null, string? model = null, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| texts | The texts to use for generating embeddings. |
| parameters | An [`EmbeddingParameters`](../../ChatGptNet.Models.Embeddings/EmbeddingParameters.md) object used to override the default embedding parameters in the [`DefaultEmbeddingParameters`](../ChatGptOptions/DefaultEmbeddingParameters.md) property. |
| model | The name of the embedding model. If *model* is `null`, then the one specified in the [`DefaultEmbeddingModel`](../ChatGptOptions/DefaultEmbeddingModel.md) property will be used. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The embeddings for the provided messages.

## Exceptions

| exception | condition |
| --- | --- |
| [EmbeddingException](../../ChatGptNet.Exceptions/EmbeddingException.md) | An error occurred while calling the API and the [`ThrowExceptionOnError`](../ChatGptOptions/ThrowExceptionOnError.md) is `true`. |

## See Also

* class [EmbeddingResponse](../../ChatGptNet.Models.Embeddings/EmbeddingResponse.md)
* class [EmbeddingParameters](../../ChatGptNet.Models.Embeddings/EmbeddingParameters.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.GenerateEmbeddingAsync method (2 of 2)

Generates embeddings for a text.

```csharp
public Task<EmbeddingResponse> GenerateEmbeddingAsync(string text, 
    EmbeddingParameters? parameters = null, string? model = null, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| text | The text to use for generating embeddings. |
| parameters | An [`EmbeddingParameters`](../../ChatGptNet.Models.Embeddings/EmbeddingParameters.md) object used to override the default embedding parameters in the [`DefaultEmbeddingParameters`](../ChatGptOptions/DefaultEmbeddingParameters.md) property. |
| model | The name of the embedding model. If *model* is `null`, then the one specified in the [`DefaultEmbeddingModel`](../ChatGptOptions/DefaultEmbeddingModel.md) property will be used. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The embeddings for the provided message.

## Exceptions

| exception | condition |
| --- | --- |
| [EmbeddingException](../../ChatGptNet.Exceptions/EmbeddingException.md) | An error occurred while calling the API and the [`ThrowExceptionOnError`](../ChatGptOptions/ThrowExceptionOnError.md) is `true`. |

## See Also

* class [EmbeddingResponse](../../ChatGptNet.Models.Embeddings/EmbeddingResponse.md)
* class [EmbeddingParameters](../../ChatGptNet.Models.Embeddings/EmbeddingParameters.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
