# IChatGptClient.AskStreamAsync method (1 of 2)

Requests a new chat interaction with streaming response, like in ChatGPT.

```csharp
public IAsyncEnumerable<ChatGptResponse> AskStreamAsync(string message, 
    ChatGptParameters? parameters = null, string? model = null, 
    bool addToConversationHistory = true, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| message | The message. |
| parameters | A [`ChatGptParameters`](../../ChatGptNet.Models/ChatGptParameters.md) object used to override the default completion parameters in the [`DefaultParameters`](../ChatGptOptions/DefaultParameters.md) property. |
| model | The chat completion model to use. If *model* is `null`, then the one specified in the [`DefaultModel`](../ChatGptOptions/DefaultModel.md) property will be used. |
| addToConversationHistory | Set to `true` to add the current chat interaction to the conversation history. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

An IAsyncEnumerable that allows to enumerate all the streaming responses, each of them containing a partial message delta.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *message* is `null`. |
| [ChatGptException](../../ChatGptNet.Exceptions/ChatGptException.md) | An error occurred while calling the API and the [`ThrowExceptionOnError`](../ChatGptOptions/ThrowExceptionOnError.md) is `true`. |

## Remarks

This method automatically starts a new conservation with a random Conversation Id, that will be returned in the [`ChatGptResponse`](../../ChatGptNet.Models/ChatGptResponse.md). Subsequent calls to this method must provide the same [`ConversationId`](../../ChatGptNet.Models/ChatGptResponse/ConversationId.md) value, so that previous messages will be automatically used to continue the conversation. When using steaming, partial message deltas will be sent. Tokens will be sent as data-only server-sent events as they become available.

## See Also

* class [ChatGptResponse](../../ChatGptNet.Models/ChatGptResponse.md)
* class [ChatGptParameters](../../ChatGptNet.Models/ChatGptParameters.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.AskStreamAsync method (2 of 2)

Requests a chat interaction with streaming response, like in ChatGPT.

```csharp
public IAsyncEnumerable<ChatGptResponse> AskStreamAsync(Guid conversationId, string message, 
    ChatGptParameters? parameters = null, string? model = null, 
    bool addToConversationHistory = true, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation, used to automatically retrieve previous messages in the chat history. |
| message | The message. |
| parameters | A [`ChatGptParameters`](../../ChatGptNet.Models/ChatGptParameters.md) object used to override the default completion parameters in the [`DefaultParameters`](../ChatGptOptions/DefaultParameters.md) property. |
| model | The chat completion model to use. If *model* is `null`, then the one specified in the [`DefaultModel`](../ChatGptOptions/DefaultModel.md) property will be used. |
| addToConversationHistory | Set to `true` to add the current chat interaction to the conversation history. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

An IAsyncEnumerable that allows to enumerate all the streaming responses, each of them containing a partial message delta.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *message* is `null`. |
| [ChatGptException](../../ChatGptNet.Exceptions/ChatGptException.md) | An error occurred while calling the API and the [`ThrowExceptionOnError`](../ChatGptOptions/ThrowExceptionOnError.md) is `true`. |

## Remarks

When using steaming, partial message deltas will be sent. Tokens will be sent as data-only server-sent events as they become available.

## See Also

* class [ChatGptResponse](../../ChatGptNet.Models/ChatGptResponse.md)
* class [ChatGptParameters](../../ChatGptNet.Models/ChatGptParameters.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
