# IChatGptClient.AddToolResponseAsync method (1 of 4)

Adds a function response to the conversation history.

```csharp
public Task AddToolResponseAsync(Guid conversationId, ChatGptFunctionCall function, string content, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| function | The [`ChatGptFunction`](../../ChatGptNet.Models/ChatGptFunction.md) to which this response refers.. |
| content | The content of the function response. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Task corresponding to the asynchronous operation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentException | *conversationId* is Empty. |
| ArgumentNullException | [`Name`](../../ChatGptNet.Models/ChatGptFunction/Name.md) or *content* are `null`. |
| InvalidOperationException | The conversation history is empty. |

## See Also

* method [AskAsync](./AskAsync.md)
* method [AskStreamAsync](./AskStreamAsync.md)
* class [ChatGptFunctionCall](../../ChatGptNet.Models/ChatGptFunctionCall.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.AddToolResponseAsync method (2 of 4)

Adds a tool response to the conversation history.

```csharp
public Task AddToolResponseAsync(Guid conversationId, ChatGptToolCall tool, string content, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| tool | The [`ChatGptToolCall`](../../ChatGptNet.Models/ChatGptToolCall.md) to which this response refers. |
| content | The content of the function response. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Task corresponding to the asynchronous operation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | [`Function`](../../ChatGptNet.Models/ChatGptToolCall/Function.md) or *content* are `null`. |
| InvalidOperationException | The conversation history is empty. |

## See Also

* method [AskAsync](./AskAsync.md)
* method [AskStreamAsync](./AskStreamAsync.md)
* class [ChatGptToolCall](../../ChatGptNet.Models/ChatGptToolCall.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.AddToolResponseAsync method (3 of 4)

Adds a function response to the conversation history.

```csharp
public Task AddToolResponseAsync(Guid conversationId, string functionName, string content, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| functionName | The name of the function. |
| content | The content of the function response. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Task corresponding to the asynchronous operation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *functionName* or *content* are `null`. |
| InvalidOperationException | The conversation history is empty. |

## See Also

* method [AskAsync](./AskAsync.md)
* method [AskStreamAsync](./AskStreamAsync.md)
* class [ChatGptFunctionCall](../../ChatGptNet.Models/ChatGptFunctionCall.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

---

# IChatGptClient.AddToolResponseAsync method (4 of 4)

Adds a tool response to the conversation history.

```csharp
public Task AddToolResponseAsync(Guid conversationId, string? toolId, string name, string content, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| toolId | The Id of the tool to which this answer refers. |
| name | The name of the tool. |
| content | The content of the function response. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Task corresponding to the asynchronous operation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *name* or *content* are `null`. |
| InvalidOperationException | The conversation history is empty. |

## See Also

* method [AskAsync](./AskAsync.md)
* method [AskStreamAsync](./AskStreamAsync.md)
* class [ChatGptToolCall](../../ChatGptNet.Models/ChatGptToolCall.md)
* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
