# IChatGptClient.AddInteractionAsync method

Explicitly adds a new interaction (a question and the corresponding answer) to an existing conversation history.

```csharp
public Task AddInteractionAsync(Guid conversationId, string question, string answer, 
    CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| question | The question. |
| answer | The answer. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Task corresponding to the asynchronous operation.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentException | *conversationId* is Empty. |
| ArgumentNullException | *question* or *answer* are `null`. |

## See Also

* interface [IChatGptClient](../IChatGptClient.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
