# IChatGptClient interface

Provides methods to interact with ChatGPT.

```csharp
public interface IChatGptClient
```

## Members

| name | description |
| --- | --- |
| [AddInteractionAsync](IChatGptClient/AddInteractionAsync.md)(…) | Explicitly adds a new interaction (a question and the corresponding answer) to an existing conversation history. |
| [AddToolResponseAsync](IChatGptClient/AddToolResponseAsync.md)(…) | Adds a function response to the conversation history. (4 methods) |
| [AskAsync](IChatGptClient/AskAsync.md)(…) | Requests a new chat interaction. (4 methods) |
| [AskStreamAsync](IChatGptClient/AskStreamAsync.md)(…) | Requests a new chat interaction with streaming response, like in ChatGPT. (2 methods) |
| [ConversationExistsAsync](IChatGptClient/ConversationExistsAsync.md)(…) | Checks if a chat conversation exists. |
| [DeleteConversationAsync](IChatGptClient/DeleteConversationAsync.md)(…) | Deletes a chat conversation, clearing all the history. |
| [GenerateEmbeddingAsync](IChatGptClient/GenerateEmbeddingAsync.md)(…) | Generates embeddings for a text. (2 methods) |
| [GetConversationAsync](IChatGptClient/GetConversationAsync.md)(…) | Retrieves a chat conversation from the cache. |
| [LoadConversationAsync](IChatGptClient/LoadConversationAsync.md)(…) | Loads messages into a new conversation. (2 methods) |
| [SetupAsync](IChatGptClient/SetupAsync.md)(…) | Setups a new conversation with a system message, that is used to influence assistant behavior. (2 methods) |

## See Also

* namespace [ChatGptNet](../ChatGptNet.md)
* [IChatGptClient.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/IChatGptClient.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
