# IChatGptCache.SetAsync method

Saves the list of messages for the given *conversationId*, using the specified *expiration*.

```csharp
public Task SetAsync(Guid conversationId, IEnumerable<ChatGptMessage> messages, 
    TimeSpan expiration, CancellationToken cancellationToken = default)
```

| parameter | description |
| --- | --- |
| conversationId | The unique identifier of the conversation. |
| messages | The list of messages. |
| expiration | The amount of time in which messages must be stored in cache. |
| cancellationToken | The token to monitor for cancellation requests. |

## Return Value

The Task corresponding to the asynchronous operation.

## See Also

* class [ChatGptMessage](../../ChatGptNet.Models/ChatGptMessage.md)
* interface [IChatGptCache](../IChatGptCache.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
