# IChatGptCache interface

Represents the interface used to define the caching behavior for ChatGPT messages.

```csharp
public interface IChatGptCache
```

## Members

| name | description |
| --- | --- |
| [ExistsAsync](IChatGptCache/ExistsAsync.md)(…) | Gets a value that indicates whether the given conversation exists in the cache. |
| [GetAsync](IChatGptCache/GetAsync.md)(…) | Gets the list of messages for the given *conversationId*. |
| [RemoveAsync](IChatGptCache/RemoveAsync.md)(…) | Removes from the cache all the message for the given *conversationId*. |
| [SetAsync](IChatGptCache/SetAsync.md)(…) | Saves the list of messages for the given *conversationId*, using the specified *expiration*. |

## See Also

* namespace [ChatGptNet](../ChatGptNet.md)
* [IChatGptCache.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/IChatGptCache.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
