# ChatGptOptionsBuilderExtensions.UseOpenAI method

Configures OpenAI settings.

```csharp
public static ChatGptOptionsBuilder UseOpenAI(this ChatGptOptionsBuilder builder, string apiKey, 
    string? organization = null)
```

| parameter | description |
| --- | --- |
| builder | The [`ChatGptOptionsBuilder`](../ChatGptOptionsBuilder.md) object to configure. |
| apiKey | The API Key to access the service. |
| organization | A value that determines the organization the user belongs to. |

## Return Value

A reference to this instance after the operation has completed.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *apiKey* is `null`. |

## Remarks

See [Where do I find my Secret API Key?](https://help.openai.com/en/articles/4936850-where-do-i-find-my-secret-api-key) for more information about the API Key. If an organization is specified, usage from these API requests will count against the specified organization's subscription quota.

## See Also

* class [ChatGptOptionsBuilder](../ChatGptOptionsBuilder.md)
* class [ChatGptOptionsBuilderExtensions](../ChatGptOptionsBuilderExtensions.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
