# ChatGptOptionsBuilderExtensions.UseAzure method

Configures Azure OpenAI Service settings.

```csharp
public static ChatGptOptionsBuilder UseAzure(this ChatGptOptionsBuilder builder, 
    string resourceName, string apiKey, string apiVersion = "2024-05-01-preview", 
    AzureAuthenticationType authenticationType = AzureAuthenticationType.ApiKey)
```

| parameter | description |
| --- | --- |
| builder | The [`ChatGptOptionsBuilder`](../ChatGptOptionsBuilder.md) object to configure. |
| resourceName | The name of the Azure OpenAI Resource. |
| apiKey | The access key to access the service. |
| apiVersion | The API version of the Azure OpenAI service |
| authenticationType | Specify if *apiKey* is an actual API Key or an Azure Active Directory token. |

## Return Value

A reference to this instance after the operation has completed.

## Exceptions

| exception | condition |
| --- | --- |
| ArgumentNullException | *resourceName*, *apiKey* or *apiVersion* are `null`. |

## Remarks

See [Azure OpenAI Service Authentication](https://learn.microsoft.com/azure/cognitive-services/openai/reference#authentication) and [Authenticating with Azure Active Directory](https://learn.microsoft.com/azure/cognitive-services/openai/how-to/managed-identity) for more information about authentication.

## See Also

* class [ChatGptOptionsBuilder](../ChatGptOptionsBuilder.md)
* enum [AzureAuthenticationType](../../ChatGptNet.ServiceConfigurations/AzureAuthenticationType.md)
* class [ChatGptOptionsBuilderExtensions](../ChatGptOptionsBuilderExtensions.md)
* namespace [ChatGptNet](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
