# ChatGptOptionsBuilder class

Builder class to define settings for configuring ChatGPT.

```csharp
public class ChatGptOptionsBuilder
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptOptionsBuilder](ChatGptOptionsBuilder/ChatGptOptionsBuilder.md)() | Initializes a new instance of the [`ChatGptOptionsBuilder`](./ChatGptOptionsBuilder.md) class. |
| [DefaultEmbeddingModel](ChatGptOptionsBuilder/DefaultEmbeddingModel.md) { get; set; } | Gets or sets the default model for embeddings. (default: [`TextEmbeddingAda002`](../ChatGptNet.Models.Embeddings/OpenAIEmbeddingModels/TextEmbeddingAda002.md) when the provider is  OpenAI). |
| [DefaultEmbeddingParameters](ChatGptOptionsBuilder/DefaultEmbeddingParameters.md) { get; set; } | Gets or sets the default parameters for embeddings. |
| [DefaultModel](ChatGptOptionsBuilder/DefaultModel.md) { get; set; } | Gets or sets the default model for chat completion. (default: [`Gpt35_Turbo`](../ChatGptNet.Models/OpenAIChatGptModels/Gpt35_Turbo.md) when the provider is  OpenAI). |
| [DefaultParameters](ChatGptOptionsBuilder/DefaultParameters.md) { get; set; } | Gets or sets the default parameters for chat completion. |
| [MessageExpiration](ChatGptOptionsBuilder/MessageExpiration.md) { get; set; } | Gets or sets the expiration for cached conversation messages (default: 1 hour). |
| [MessageLimit](ChatGptOptionsBuilder/MessageLimit.md) { get; set; } | Gets or sets the maximum number of messages to use for chat completion (default: 10). |
| [ThrowExceptionOnError](ChatGptOptionsBuilder/ThrowExceptionOnError.md) { get; set; } | Gets or sets a value that determines whether to throw a [`ChatGptException`](../ChatGptNet.Exceptions/ChatGptException.md) when an error occurred (default: `true`). If this property is set to `false`, API errors are returned in the [`ChatGptResponse`](../ChatGptNet.Models/ChatGptResponse.md) object. |
| [User](ChatGptOptionsBuilder/User.md) { get; set; } | Gets or sets the user identification for chat completion, which can help OpenAI to monitor and detect abuse. |

## See Also

* namespace [ChatGptNet](../ChatGptNet.md)
* [ChatGptOptionsBuilder.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/ChatGptOptionsBuilder.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
