# ChatGptOptions class

Options class that provides settings for configuring ChatGPT.

```csharp
public class ChatGptOptions
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptOptions](ChatGptOptions/ChatGptOptions.md)() | The default constructor. |
| [DefaultEmbeddingModel](ChatGptOptions/DefaultEmbeddingModel.md) { get; set; } | Gets or sets the default model for embedding. (default: [`TextEmbeddingAda002`](../ChatGptNet.Models.Embeddings/OpenAIEmbeddingModels/TextEmbeddingAda002.md) when the provider is OpenAI). |
| [DefaultEmbeddingParameters](ChatGptOptions/DefaultEmbeddingParameters.md) { get; } | Gets or sets the default parameters for embeddings. |
| [DefaultModel](ChatGptOptions/DefaultModel.md) { get; set; } | Gets or sets the default model for chat completion. (default: [`Gpt35_Turbo`](../ChatGptNet.Models/OpenAIChatGptModels/Gpt35_Turbo.md) when the provider is OpenAI). |
| [DefaultParameters](ChatGptOptions/DefaultParameters.md) { get; } | Gets or sets the default parameters for chat completion. |
| [MessageExpiration](ChatGptOptions/MessageExpiration.md) { get; set; } | Gets or sets the expiration for cached conversation messages (default: 1 hour). |
| [MessageLimit](ChatGptOptions/MessageLimit.md) { get; set; } | Gets or sets the maximum number of messages to use for chat completion (default: 10). |
| [ThrowExceptionOnError](ChatGptOptions/ThrowExceptionOnError.md) { get; set; } | Gets or sets a value that determines whether to throw a [`ChatGptException`](../ChatGptNet.Exceptions/ChatGptException.md) when an error occurred (default: `true`). If this property is set to `false`, API errors are returned in the [`ChatGptResponse`](../ChatGptNet.Models/ChatGptResponse.md) object. |
| [User](ChatGptOptions/User.md) { get; set; } | Gets or sets the user identification for chat completion, which can help OpenAI to monitor and detect abuse. |

## See Also

* namespace [ChatGptNet](../ChatGptNet.md)
* [ChatGptOptions.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/ChatGptOptions.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
