# OpenAIChatGptModels class

Contains all the chat completion models that are currently supported by OpenAI.

```csharp
public static class OpenAIChatGptModels
```

## Public Members

| name | description |
| --- | --- |
| const [Gpt35_Turbo](OpenAIChatGptModels/Gpt35_Turbo.md) | GPT-3.5 model can understand and generate natural language or code and it is optimized for chat. |
| const [Gpt35_Turbo_16k](OpenAIChatGptModels/Gpt35_Turbo_16k.md) | A model with the same capabilities as the standard [`Gpt35_Turbo`](./OpenAIChatGptModels/Gpt35_Turbo.md) model but with 4 times the token limit of [`Gpt35_Turbo`](./OpenAIChatGptModels/Gpt35_Turbo.md). |
| const [Gpt4](OpenAIChatGptModels/Gpt4.md) | GPT-4 is a large multimodal model that can solve difficult problems with greater accuracy than any of our previous models, thanks to its broader general knowledge and advanced reasoning capabilities. is optimized for chat but works well for traditional completions tasks. |
| const [Gpt4_32k](OpenAIChatGptModels/Gpt4_32k.md) | A model with the same capabilities as the base [`Gpt4`](./OpenAIChatGptModels/Gpt4.md) model but with 4 times the token limit of [`Gpt4`](./OpenAIChatGptModels/Gpt4.md). |
| const [Gpt4_o](OpenAIChatGptModels/Gpt4_o.md) | The most advanced, multimodal flagship model that’s cheaper and faster than [`Gpt4_Turbo`](./OpenAIChatGptModels/Gpt4_Turbo.md). |
| const [Gpt4_Turbo](OpenAIChatGptModels/Gpt4_Turbo.md) | The latest GPT-4 model with vision capabilities and improved instruction following, JSON mode, reproducible outputs, parallel function calling, and more. |

## Remarks

See [Models overview](https://platform.openai.com/docs/models/overview) for more information.

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [OpenAIChatGptModels.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/OpenAIChatGptModels.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
