# ChatGptToolParameters.FunctionCall property

Controls which (if any) function is called by the model.

```csharp
public string? FunctionCall { get; set; }
```

## Remarks

* **[`None`](../ChatGptToolChoices/None.md)** – Model will not call a function and instead generates a message.
* **[`Auto`](../ChatGptToolChoices/Auto.md)** – The model can pick between generating a message or calling a function.
* **function_name** – Specifying a particular function name forces the model to call that function.

[`None`](../ChatGptToolChoices/None.md) is the default when no functions are present. [`None`](../ChatGptToolChoices/None.md) is the default if functions are present.

## See Also

* property [Functions](./Functions.md)
* class [ChatGptFunction](../ChatGptFunction.md)
* class [ChatGptToolParameters](../ChatGptToolParameters.md)
* namespace [ChatGptNet.Models](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
