# ChatGptResponse class

Represents a chat completion response.

```csharp
public class ChatGptResponse : Response
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptResponse](ChatGptResponse/ChatGptResponse.md)() | The default constructor. |
| [Choices](ChatGptResponse/Choices.md) { get; set; } | Gets or sets the list of choices that has been provided by chat completion. |
| [ConversationId](ChatGptResponse/ConversationId.md) { get; set; } | Gets or sets the Conversation Id, that is used to group messages of the same conversation. |
| [CreatedAt](ChatGptResponse/CreatedAt.md) { get; set; } | Gets or sets the UTC date and time at which the response has been generated. |
| [Id](ChatGptResponse/Id.md) { get; set; } | Gets or sets the Id of the response. |
| [IsContentFiltered](ChatGptResponse/IsContentFiltered.md) { get; } | Gets a value indicating whether the first choice, if available, has been filtered by the content filtering system. |
| [IsPromptFiltered](ChatGptResponse/IsPromptFiltered.md) { get; } | Gets or sets a value indicating whether any prompt has been filtered by the content filtering system. |
| [PromptFilterResults](ChatGptResponse/PromptFilterResults.md) { get; set; } | Gets or sets the list of prompt filter results determined by the content filtering system. |
| [SystemFingerprint](ChatGptResponse/SystemFingerprint.md) { get; set; } | This fingerprint represents the backend configuration that the model runs with. Can be used in conjunction with the [`Seed`](./ChatGptParameters/Seed.md) request parameter to understand when backend changes have been made that might impact determinism. |

## See Also

* class [Response](../ChatGptNet.Models.Common/Response.md)
* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptResponse.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptResponse.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
