# ChatGptParameters class

Represents chat completion parameters.

```csharp
public class ChatGptParameters
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptParameters](ChatGptParameters/ChatGptParameters.md)() | The default constructor. |
| [FrequencyPenalty](ChatGptParameters/FrequencyPenalty.md) { get; set; } | Gets or sets the frequency penalties for chat completion. Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim (default: 0). |
| [LogProbabilities](ChatGptParameters/LogProbabilities.md) { get; set; } | Gets or set a value that determines whether to return log probabilities of the output tokens or not. If `true`, returns the log probabilities of each output token returned in the content of message (default: `false`). |
| [MaxTokens](ChatGptParameters/MaxTokens.md) { get; set; } | Gets or sets the maximum number of tokens to generate in the chat completion. The total length of input tokens and generated tokens is limited by the model's context length. |
| [PresencePenalty](ChatGptParameters/PresencePenalty.md) { get; set; } | Gets or sets the presence penalties for chat completion. Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics (default: 0). |
| [ResponseFormat](ChatGptParameters/ResponseFormat.md) { get; set; } | An object specifying the format that the model must output. Used to enable JSON mode. |
| [Seed](ChatGptParameters/Seed.md) { get; set; } | Gets or sets a value such that, if specified, the system will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. |
| [Temperature](ChatGptParameters/Temperature.md) { get; set; } | Gets or sets what sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic (default: 1). |
| [TopLogProbabilities](ChatGptParameters/TopLogProbabilities.md) { get; set; } | Gets or sets a value between 0 and 5 specifying the number of most likely tokens to return at each token position, each with an associated log probability. |
| [TopP](ChatGptParameters/TopP.md) { get; set; } | Gets or sets an alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with [`TopP`](./ChatGptParameters/TopP.md) probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered (default: 1). |

## Remarks

See [Create chat completion](https://platform.openai.com/docs/api-reference/chat/create) for more information.

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptParameters.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptParameters.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
