# ChatGptMessage class

Represents a single chat message.

```csharp
public class ChatGptMessage
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptMessage](ChatGptMessage/ChatGptMessage.md)() | The default constructor. |
| [Content](ChatGptMessage/Content.md) { get; set; } | Gets or sets the content of the message. |
| [FunctionCall](ChatGptMessage/FunctionCall.md) { get; set; } | Gets or sets the function call for the message, if any. |
| [Name](ChatGptMessage/Name.md) { get; set; } | Gets or sets the name of the author of this message. |
| [Role](ChatGptMessage/Role.md) { get; set; } | Gets or sets the role (source) of the message author. |
| [ToolCallId](ChatGptMessage/ToolCallId.md) { get; set; } | Gets or sets the Id of the tool call related to this message. |
| [ToolCalls](ChatGptMessage/ToolCalls.md) { get; set; } | The tool calls generated by the model, such as function calls. |

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptMessage.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptMessage.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
