# ChatGptLogProbabilityContent class

Represents a message content token with log probability information.

```csharp
public class ChatGptLogProbabilityContent
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptLogProbabilityContent](ChatGptLogProbabilityContent/ChatGptLogProbabilityContent.md)() | The default constructor. |
| [Bytes](ChatGptLogProbabilityContent/Bytes.md) { get; set; } | Gets or sets a list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token. |
| [LogProbality](ChatGptLogProbabilityContent/LogProbality.md) { get; set; } | Gets or sets the log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value -9999.0 is used to signify that the token is very unlikely. |
| [Token](ChatGptLogProbabilityContent/Token.md) { get; set; } | Gets or sets the token. |
| [TopLogProbabilities](ChatGptLogProbabilityContent/TopLogProbabilities.md) { get; set; } | Gets or sets the list of the most likely tokens and their log probability, at this token position. In rare cases, there may be fewer than the number of requested [`TopLogProbabilities`](./ChatGptParameters/TopLogProbabilities.md) returned. |

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptLogProbabilityContent.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptLogProbabilityContent.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
