# ChatGptError class

Contains information about the error occurred while invoking the service.

```csharp
public class ChatGptError
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptError](ChatGptError/ChatGptError.md)() | The default constructor. |
| [Code](ChatGptError/Code.md) { get; set; } | Gets or sets the error code. |
| [InnerError](ChatGptError/InnerError.md) { get; set; } | Contains further details about the error. |
| [Message](ChatGptError/Message.md) { get; set; } | Gets or sets the error message. |
| [Parameter](ChatGptError/Parameter.md) { get; set; } | Gets or sets the parameter that caused the error. |
| [StatusCode](ChatGptError/StatusCode.md) { get; set; } | Gets or sets the HTTP status code of the error. |
| [Type](ChatGptError/Type.md) { get; set; } | Gets or sets the error type. |

## Remarks

See [Error codes](https://platform.openai.com/docs/guides/error-codes) for more information.

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptError.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptError.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
