# ChatGptContentFilterSeverityLevels class

Contains all the content filter severity levels defined by Azure OpenAI Service.

```csharp
public static class ChatGptContentFilterSeverityLevels
```

## Public Members

| name | description |
| --- | --- |
| const [High](ChatGptContentFilterSeverityLevels/High.md) | Content that displays explicit and severe harmful instructions, actions, damage, or abuse; includes endorsement, glorification, or promotion of severe harmful acts, extreme or illegal forms of harm, radicalization, or non-consensual power exchange or abuse. |
| const [Low](ChatGptContentFilterSeverityLevels/Low.md) | Content that expresses prejudiced, judgmental, or opinionated views, includes offensive use of language, stereotyping, use cases exploring a fictional world (for example, gaming, literature) and depictions at low intensity. |
| const [Medium](ChatGptContentFilterSeverityLevels/Medium.md) | Content that uses offensive, insulting, mocking, intimidating, or demeaning language towards specific identity groups, includes depictions of seeking and executing harmful instructions, fantasies, glorification, promotion of harm at medium intensity. |
| const [Safe](ChatGptContentFilterSeverityLevels/Safe.md) | Content may be related to violence, self-harm, sexual, or hate categories but the terms are used in general, journalistic, scientific, medical, and similar professional contexts, which are appropriate for most audiences. |

## Remarks

See [Content filtering](https://learn.microsoft.com/azure/ai-services/openai/concepts/content-filter#severity-levels) for more information.

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptContentFilterSeverityLevels.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptContentFilterSeverityLevels.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
