# ChatGptContentFilterResult.Severity property

Gets or sets the severity levels of the content.

```csharp
public string Severity { get; set; }
```

## Remarks

Currently supported severity levels are:

* **Safe** – Content may be related to violence, self-harm, sexual, or hate categories but the terms are used in general, journalistic, scientific, medical, and similar professional contexts, which are appropriate for most audiences.
* **Low** – Content that expresses prejudiced, judgmental, or opinionated views, includes offensive use of language, stereotyping, use cases exploring a fictional world (for example, gaming, literature) and depictions at low intensity.
* **Medium** – Content that uses offensive, insulting, mocking, intimidating, or demeaning language towards specific identity groups, includes depictions of seeking and executing harmful instructions, fantasies, glorification, promotion of harm at medium intensity.
* **High** – Content that displays explicit and severe harmful instructions, actions, damage, or abuse; includes endorsement, glorification, or promotion of severe harmful acts, extreme or illegal forms of harm, radicalization, or non-consensual power exchange or abuse.

## See Also

* class [ChatGptContentFilterSeverityLevels](../ChatGptContentFilterSeverityLevels.md)
* class [ChatGptContentFilterResult](../ChatGptContentFilterResult.md)
* namespace [ChatGptNet.Models](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
