# ChatGptChoice class

Represent a chat completion choice.

```csharp
public class ChatGptChoice
```

## Public Members

| name | description |
| --- | --- |
| [ChatGptChoice](ChatGptChoice/ChatGptChoice.md)() | The default constructor. |
| [ContentFilterResults](ChatGptChoice/ContentFilterResults.md) { get; set; } | Gets or sets the content filter results for the this [`ChatGptChoice`](./ChatGptChoice.md). |
| [Delta](ChatGptChoice/Delta.md) { get; set; } | When using streaming responses, gets or sets the partial message delta associated with this [`ChatGptChoice`](./ChatGptChoice.md). |
| [FinishReason](ChatGptChoice/FinishReason.md) { get; set; } | Gets or sets a value specifying why the choice has been returned. |
| [Index](ChatGptChoice/Index.md) { get; set; } | Gets or sets the index of the choice in the list. |
| [IsFiltered](ChatGptChoice/IsFiltered.md) { get; } | Gets or sets a value indicating whether the this [`ChatGptChoice`](./ChatGptChoice.md) has been filtered by the content filtering system. |
| [LogProbabilities](ChatGptChoice/LogProbabilities.md) { get; set; } | Gets or sets the log probabilities associated with this [`ChatGptChoice`](./ChatGptChoice.md). |
| [Message](ChatGptChoice/Message.md) { get; set; } | Gets or sets the message associated with this [`ChatGptChoice`](./ChatGptChoice.md), if any. |

## See Also

* namespace [ChatGptNet.Models](../ChatGptNet.md)
* [ChatGptChoice.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/ChatGptChoice.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
