# OpenAIEmbeddingModels class

Contains all the embedding models that are currently supported by OpenAI.

```csharp
public static class OpenAIEmbeddingModels
```

## Public Members

| name | description |
| --- | --- |
| const [TextEmbedding3Large](OpenAIEmbeddingModels/TextEmbedding3Large.md) | Most capable embedding model for both english and non-english tasks. It uses a 3072 output dimension. |
| const [TextEmbedding3Small](OpenAIEmbeddingModels/TextEmbedding3Small.md) | Increased performance over 2nd generation ada embedding model. It uses a 1536 output dimension. |
| const [TextEmbeddingAda002](OpenAIEmbeddingModels/TextEmbeddingAda002.md) | The second generation embedding model provided by OpenAI. It uses a 1536 output dimension. |

## Remarks

See [Models overview](https://platform.openai.com/docs/models/embeddings) for more information.

## See Also

* namespace [ChatGptNet.Models.Embeddings](../ChatGptNet.md)
* [OpenAIEmbeddingModels.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/Embeddings/OpenAIEmbeddingModels.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
