# Response class

Contains common properties for all response types.

```csharp
public abstract class Response
```

## Public Members

| name | description |
| --- | --- |
| [Error](Response/Error.md) { get; set; } | Gets or sets the error occurred during the chat completion execution, if any. |
| [IsSuccessful](Response/IsSuccessful.md) { get; } | Gets a value that determines if the response was successful. |
| [Model](Response/Model.md) { get; set; } | Gets or sets the model name that has been used to generate the response. |
| [Object](Response/Object.md) { get; set; } | Gets or sets the source object for this response. |
| [Usage](Response/Usage.md) { get; set; } | Gets or sets information about token usage. |

## Protected Members

| name | description |
| --- | --- |
| [Response](Response/Response.md)() | The default constructor. |

## See Also

* namespace [ChatGptNet.Models.Common](../ChatGptNet.md)
* [Response.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Models/Common/Response.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
