# EmbeddingUtility.CosineSimilarity method (1 of 3)

Computes the cosine similarity between the results of two embedding requests.

```csharp
public static float CosineSimilarity(this EmbeddingResponse embeddingResponse, 
    EmbeddingResponse otherResponse)
```

| parameter | description |
| --- | --- |
| embeddingResponse | The first embedding response. |
| otherResponse | The second embedding response. |

## Return Value

The cosine similarity.

## See Also

* method [GenerateEmbeddingAsync](../../ChatGptNet/IChatGptClient/GenerateEmbeddingAsync.md)
* class [EmbeddingResponse](../../ChatGptNet.Models.Embeddings/EmbeddingResponse.md)
* class [EmbeddingUtility](../EmbeddingUtility.md)
* namespace [ChatGptNet.Extensions](../../ChatGptNet.md)

---

# EmbeddingUtility.CosineSimilarity method (2 of 3)

Computes the cosine similarity between the result of an embedding request and another vector.

```csharp
public static float CosineSimilarity(this EmbeddingResponse embeddingResponse, 
    ReadOnlySpan<float> y)
```

| parameter | description |
| --- | --- |
| embeddingResponse | The embedding response. |
| y | The other vector. |

## Return Value

The cosine similarity.

## See Also

* method [GenerateEmbeddingAsync](../../ChatGptNet/IChatGptClient/GenerateEmbeddingAsync.md)
* class [EmbeddingResponse](../../ChatGptNet.Models.Embeddings/EmbeddingResponse.md)
* class [EmbeddingUtility](../EmbeddingUtility.md)
* namespace [ChatGptNet.Extensions](../../ChatGptNet.md)

---

# EmbeddingUtility.CosineSimilarity method (3 of 3)

Computes the cosine similarity between two vectors.

```csharp
public static float CosineSimilarity(ReadOnlySpan<float> x, ReadOnlySpan<float> y)
```

| parameter | description |
| --- | --- |
| x | The first vector. |
| y | The second vector. |

## Return Value

The cosine similarity.

## See Also

* class [EmbeddingUtility](../EmbeddingUtility.md)
* namespace [ChatGptNet.Extensions](../../ChatGptNet.md)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
