# ChatGptResponseExtensions class

Provides extension methods for the [`ChatGptResponse`](../ChatGptNet.Models/ChatGptResponse.md) class.

```csharp
public static class ChatGptResponseExtensions
```

## Public Members

| name | description |
| --- | --- |
| static [AsDeltas](ChatGptResponseExtensions/AsDeltas.md)(…) | Returns an IAsyncEnumerable that allows to enumerate all the partial message deltas. |
| static [ContainsFunctionCalls](ChatGptResponseExtensions/ContainsFunctionCalls.md)(…) | Gets a value indicating whether the first choice, if available, contains a function call. |
| static [ContainsToolCalls](ChatGptResponseExtensions/ContainsToolCalls.md)(…) | Gets a value indicating whether the first choice, if available, contains a tool call. |
| static [GetContent](ChatGptResponseExtensions/GetContent.md)(…) | Gets the content of the first choice, if available. |
| static [GetFunctionCall](ChatGptResponseExtensions/GetFunctionCall.md)(…) | Gets or sets the function call for the message of the first choice, if available. |
| static [GetToolCalls](ChatGptResponseExtensions/GetToolCalls.md)(…) | Gets the tool calls for the message of the first choice, if available. |

## See Also

* class [ChatGptResponse](../ChatGptNet.Models/ChatGptResponse.md)
* namespace [ChatGptNet.Extensions](../ChatGptNet.md)
* [ChatGptResponseExtensions.cs](https://github.com/marcominerva/ChatGptNet/tree/master/src/ChatGptNet/Extensions/ChatGptResponseExtensions.cs)

<!-- DO NOT EDIT: generated by xmldocmd for ChatGptNet.dll -->
