import { Fragment } from "react";
import styles from "../styles/Highlight.module.css";

const parseLine = (line) => {
  const buff = [{ className: null, content: "" }];
  let isString = false;

  for (let char of line) {
    let curr = buff[buff.length - 1];

    switch (char) {
      case '"':
        if (isString) {
          curr.content += char;
          isString = false;
          break;
        } else if (curr.className == null || curr.className !== styles.string) {
          isString = true;
          curr.className = styles.string;
          curr.content = char;
          break;
        }
        break;

      case " ":
        if (!isString) {
          curr = { className: null, content: "" };
          buff.push(curr);
          break;
        }
      // eslist-disable-line no-fallthrough
      default:
        if (curr.className == null) {
          curr.className = styles.number;
        }
        curr.content += char;
        break;
    }
  }

  return buff;
};

export default function Highlight({ content }) {
  if (!content) return null;

  const lines = content.split("\n");

  for (let i = 0; i < lines.length; ++i) {
    const line = lines[i];

    if (line.startsWith("#")) {
      lines[i] = <span className={styles.comment}>{line}</span>;
    } else if (line.startsWith("*")) {
      lines[i] = <span className={styles.heading}>{line}</span>;
    } else {
      lines[i] = parseLine(line).map(({ className, content }, i) => (
        <Fragment key={i}>
          <span className={className}>{content}</span>{" "}
        </Fragment>
      ));
    }
  }

  return (
    <>
      {lines.map((line, i) => (
        <Fragment key={i}>
          {line}
          <br />
        </Fragment>
      ))}
    </>
  );
}
