Created using IntelliJ and Spring Initializr plugin for Spring Boot web and Gradle. So, basic framework web configuration was generated by default.

# Working with JSP

## Step 1: Create index.jsp
If you want to work with JSPs, you need to create new directories under main:

- webapp
  - WEB-INF
      - jsp
        - index.jsp

## Step 2: Edit (or create) application.properties
Add this to application.properties (you should create it inside resource directory if it isn't)

```
spring.mvc.view.prefix=/WEB-INF/jsp/
spring.mvc.view.suffix=.jsp
```
## Step 3: Add dependencies in build.gradle
You can copy these lines but **you should use the packages versions that fits you**. Check the links below and search what you want. However you've got to use **providedCompile group** instead of **compile group** 
```
// https://mvnrepository.com/artifact/org.apache.tomcat.embed/tomcat-embed-core
providedCompile group: 'org.apache.tomcat.embed', name: 'tomcat-embed-core', version: '9.0.0.M22'
// https://mvnrepository.com/artifact/javax.servlet/javax.servlet-api
providedCompile group: 'javax.servlet', name: 'javax.servlet-api', version: '3.0.1'
```
## Step 4: Add proper controller
```
@Controller
public class MainController {
    @GetMapping("/")
    public String home(){
        return "index";
    }
}
```
